/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.parse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.opensaml.xml.parse.LoggingErrorHandler;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StaticBasicParserPool
implements ParserPool {
    private final Logger log = LoggerFactory.getLogger(StaticBasicParserPool.class);
    private boolean initialized = false;
    private DocumentBuilderFactory builderFactory;
    private Stack<SoftReference<DocumentBuilder>> builderPool = new Stack();
    private int maxPoolSize = 5;
    private Map<String, Object> builderAttributes = new LazyMap<String, Object>();
    private boolean coalescing = true;
    private boolean expandEntityReferences = false;
    private Map<String, Boolean> builderFeatures = this.buildDefaultFeatures();
    private boolean ignoreComments = true;
    private boolean ignoreElementContentWhitespace = true;
    private boolean namespaceAware = true;
    private Schema schema = null;
    private boolean dtdValidating = false;
    private boolean xincludeAware = false;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new LoggingErrorHandler(this.log);

    public synchronized void initialize() throws XMLParserException {
        if (this.initialized) {
            throw new XMLParserException("Parser pool was already initialized");
        }
        this.initializeFactory();
        this.initialized = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentBuilder getBuilder() throws XMLParserException {
        DocumentBuilder builder = null;
        if (!this.initialized) {
            throw new XMLParserException("Parser pool has not been initialized");
        }
        Stack<SoftReference<DocumentBuilder>> stack = this.builderPool;
        synchronized (stack) {
            if (!this.builderPool.isEmpty()) {
                builder = this.builderPool.pop().get();
            }
        }
        if (builder == null) {
            builder = this.createBuilder();
        }
        if (builder != null) {
            return new DocumentBuilderProxy(builder, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuilder(DocumentBuilder builder) {
        if (!(builder instanceof DocumentBuilderProxy)) {
            return;
        }
        DocumentBuilderProxy proxiedBuilder = (DocumentBuilderProxy)builder;
        if (proxiedBuilder.getOwningPool() != this) {
            return;
        }
        DocumentBuilderProxy documentBuilderProxy = proxiedBuilder;
        synchronized (documentBuilderProxy) {
            if (proxiedBuilder.isReturned()) {
                return;
            }
            proxiedBuilder.setReturned(true);
        }
        DocumentBuilder unwrappedBuilder = proxiedBuilder.getProxiedBuilder();
        unwrappedBuilder.reset();
        SoftReference<DocumentBuilder> builderReference = new SoftReference<DocumentBuilder>(unwrappedBuilder);
        Stack<SoftReference<DocumentBuilder>> stack = this.builderPool;
        synchronized (stack) {
            if (this.builderPool.size() < this.maxPoolSize) {
                this.builderPool.push(builderReference);
            }
        }
    }

    @Override
    public Document newDocument() throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        Document document = builder.newDocument();
        this.returnBuilder(builder);
        return document;
    }

    @Override
    public Document parse(InputStream input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(input);
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    @Override
    public Document parse(Reader input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(new InputSource(input));
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int newSize) {
        this.checkValidModifyState();
        this.maxPoolSize = newSize;
    }

    public Map<String, Object> getBuilderAttributes() {
        return Collections.unmodifiableMap(this.builderAttributes);
    }

    public void setBuilderAttributes(Map<String, Object> newAttributes) {
        this.checkValidModifyState();
        this.builderAttributes = newAttributes;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean isCoalescing) {
        this.checkValidModifyState();
        this.coalescing = isCoalescing;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public void setExpandEntityReferences(boolean expand) {
        this.checkValidModifyState();
        this.expandEntityReferences = expand;
    }

    public Map<String, Boolean> getBuilderFeatures() {
        return Collections.unmodifiableMap(this.builderFeatures);
    }

    public void setBuilderFeatures(Map<String, Boolean> newFeatures) {
        this.checkValidModifyState();
        this.builderFeatures = newFeatures;
    }

    public boolean getIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignore) {
        this.checkValidModifyState();
        this.ignoreComments = ignore;
    }

    public boolean isIgnoreElementContentWhitespace() {
        return this.ignoreElementContentWhitespace;
    }

    public void setIgnoreElementContentWhitespace(boolean ignore) {
        this.checkValidModifyState();
        this.ignoreElementContentWhitespace = ignore;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.checkValidModifyState();
        this.namespaceAware = isNamespaceAware;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public synchronized void setSchema(Schema newSchema) {
        this.checkValidModifyState();
        this.schema = newSchema;
        if (this.schema != null) {
            this.setNamespaceAware(true);
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaSource");
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
        }
    }

    public boolean isDTDValidating() {
        return this.dtdValidating;
    }

    public void setDTDValidating(boolean isValidating) {
        this.checkValidModifyState();
        this.dtdValidating = isValidating;
    }

    public boolean isXincludeAware() {
        return this.xincludeAware;
    }

    public void setXincludeAware(boolean isXIncludeAware) {
        this.checkValidModifyState();
        this.xincludeAware = isXIncludeAware;
    }

    protected int getPoolSize() {
        return this.builderPool.size();
    }

    protected void checkValidModifyState() {
        if (this.initialized) {
            throw new IllegalStateException("Pool is already initialized, property changes not allowed");
        }
    }

    protected synchronized void initializeFactory() throws XMLParserException {
        DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
        this.setAttributes(newFactory, this.builderAttributes);
        this.setFeatures(newFactory, this.builderFeatures);
        newFactory.setCoalescing(this.coalescing);
        newFactory.setExpandEntityReferences(this.expandEntityReferences);
        newFactory.setIgnoringComments(this.ignoreComments);
        newFactory.setIgnoringElementContentWhitespace(this.ignoreElementContentWhitespace);
        newFactory.setNamespaceAware(this.namespaceAware);
        newFactory.setSchema(this.schema);
        newFactory.setValidating(this.dtdValidating);
        newFactory.setXIncludeAware(this.xincludeAware);
        this.builderFactory = newFactory;
    }

    protected void setAttributes(DocumentBuilderFactory factory, Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            try {
                this.log.debug("Setting DocumentBuilderFactory attribute '{}'", (Object)attribute.getKey());
                factory.setAttribute(attribute.getKey(), attribute.getValue());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("DocumentBuilderFactory attribute '{}' is not supported", (Object)attribute.getKey());
            }
        }
    }

    protected void setFeatures(DocumentBuilderFactory factory, Map<String, Boolean> features) {
        if (features == null || features.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Boolean> feature : features.entrySet()) {
            try {
                this.log.debug("Setting DocumentBuilderFactory attribute '{}'", (Object)feature.getKey());
                factory.setFeature(feature.getKey(), feature.getValue());
            }
            catch (ParserConfigurationException e) {
                this.log.warn("DocumentBuilderFactory feature '{}' is not supported", (Object)feature.getKey());
            }
        }
    }

    protected DocumentBuilder createBuilder() throws XMLParserException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            if (this.entityResolver != null) {
                builder.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                builder.setErrorHandler(this.errorHandler);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            this.log.error("Unable to create new document builder", (Throwable)e);
            throw new XMLParserException("Unable to create new document builder", e);
        }
    }

    protected Map<String, Boolean> buildDefaultFeatures() {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        return features;
    }

    protected class DocumentBuilderProxy
    extends DocumentBuilder {
        private DocumentBuilder builder;
        private ParserPool owningPool;
        private boolean returned;

        public DocumentBuilderProxy(DocumentBuilder target, StaticBasicParserPool owner) {
            this.owningPool = owner;
            this.builder = target;
            this.returned = false;
        }

        @Override
        public DOMImplementation getDOMImplementation() {
            this.checkValidState();
            return this.builder.getDOMImplementation();
        }

        @Override
        public Schema getSchema() {
            this.checkValidState();
            return this.builder.getSchema();
        }

        @Override
        public boolean isNamespaceAware() {
            this.checkValidState();
            return this.builder.isNamespaceAware();
        }

        @Override
        public boolean isValidating() {
            this.checkValidState();
            return this.builder.isValidating();
        }

        @Override
        public boolean isXIncludeAware() {
            this.checkValidState();
            return this.builder.isXIncludeAware();
        }

        @Override
        public Document newDocument() {
            this.checkValidState();
            return this.builder.newDocument();
        }

        @Override
        public Document parse(File f) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(f);
        }

        @Override
        public Document parse(InputSource is) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is);
        }

        @Override
        public Document parse(InputStream is) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is);
        }

        @Override
        public Document parse(InputStream is, String systemId) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(is, systemId);
        }

        @Override
        public Document parse(String uri) throws SAXException, IOException {
            this.checkValidState();
            return this.builder.parse(uri);
        }

        @Override
        public void reset() {
        }

        @Override
        public void setEntityResolver(EntityResolver er) {
            this.checkValidState();
        }

        @Override
        public void setErrorHandler(ErrorHandler eh) {
            this.checkValidState();
        }

        protected ParserPool getOwningPool() {
            return this.owningPool;
        }

        protected DocumentBuilder getProxiedBuilder() {
            return this.builder;
        }

        protected boolean isReturned() {
            return this.returned;
        }

        protected void setReturned(boolean isReturned) {
            this.returned = isReturned;
        }

        protected void checkValidState() throws IllegalStateException {
            if (this.isReturned()) {
                throw new IllegalStateException("DocumentBuilderProxy has already been returned to its owning pool");
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.owningPool.returnBuilder(this);
        }
    }
}

