/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.CliShutdownHook;
import org.jboss.as.cli.impl.ModelControllerClientFactory;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolTimeoutHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class CLIModelControllerClient
extends AbstractModelControllerClient {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.EMPTY;
    private static final ThreadPoolExecutor executorService;
    private static final Endpoint endpoint;
    private static final byte CLOSED = 0;
    private static final byte CONNECTING = 1;
    private static final byte CONNECTED = 2;
    private static final byte LOST_CONNECTION = 3;
    private final Object lock = new Object();
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SSLContext sslContext;
    private final ModelControllerClientFactory.ConnectionCloseHandler closeHandler;
    private final ManagementChannelHandler channelAssociation;
    private ManagementClientChannelStrategy strategy;
    private final ProtocolChannelClient.Configuration channelConfig;
    private final AtomicInteger state = new AtomicInteger(0);

    CLIModelControllerClient(ControllerAddress address, CallbackHandler handler, int connectionTimeout, ModelControllerClientFactory.ConnectionCloseHandler closeHandler, Map<String, String> saslOptions, SSLContext sslContext, ProtocolTimeoutHandler timeoutHandler, String clientBindAddress) throws IOException {
        this.handler = handler;
        this.sslContext = sslContext;
        this.closeHandler = closeHandler;
        this.channelAssociation = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            public Channel getChannel() throws IOException {
                return CLIModelControllerClient.this.getOrCreateChannel();
            }

            public void close() throws IOException {
            }
        }, (ExecutorService)executorService, new ManagementRequestHandlerFactory[]{this});
        this.channelConfig = new ProtocolChannelClient.Configuration();
        this.channelConfig.setClientBindAddress(clientBindAddress);
        this.saslOptions = saslOptions;
        this.channelConfig.setSaslOptions(saslOptions);
        try {
            this.channelConfig.setUri(new URI(address.getProtocol(), null, address.getHost(), address.getPort(), null, null, null));
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to create URI", e);
        }
        this.channelConfig.setOptionMap(DEFAULT_OPTIONS);
        if (connectionTimeout > 0) {
            this.channelConfig.setConnectionTimeout((long)connectionTimeout);
        }
        this.channelConfig.setEndpoint(endpoint);
        this.channelConfig.setTimeoutHandler(timeoutHandler);
    }

    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel getOrCreateChannel() throws IOException {
        Channel ch = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.strategy == null) {
                ProtocolChannelClient setup = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)this.channelConfig);
                ChannelCloseHandler channelCloseHandler = new ChannelCloseHandler();
                this.strategy = ManagementClientChannelStrategy.create((ProtocolChannelClient)setup, (ManagementMessageHandler)this.channelAssociation, (CallbackHandler)this.handler, this.saslOptions, (SSLContext)this.sslContext, (CloseHandler)channelCloseHandler);
                channelCloseHandler.setOriginalStrategy(this.strategy);
            }
            this.state.set(1);
            ch = this.strategy.getChannel();
            if (this.state.get() == 3) {
                this.close();
            } else {
                this.state.set(2);
            }
            this.lock.notifyAll();
        }
        return ch;
    }

    public boolean isConnected() {
        return this.strategy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.state.get() == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state.get() == 0) {
                return;
            }
            this.state.set(0);
            this.channelAssociation.shutdown();
            if (this.strategy != null) {
                StreamUtils.safeClose((Closeable)this.strategy);
                this.strategy = null;
            }
            this.channelAssociation.shutdownNow();
            try {
                this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelNode execute(ModelNode operation, boolean awaitClose) throws IOException {
        ModelNode response = super.execute(operation);
        if (!Util.isSuccess(response)) {
            return response;
        }
        if (awaitClose) {
            Object object = this.lock;
            synchronized (object) {
                if (this.strategy != null) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    StreamUtils.safeClose((Closeable)this.strategy);
                    this.strategy = null;
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureConnected(long timeoutMillis) throws CommandLineException {
        boolean doTry = true;
        long start = System.currentTimeMillis();
        IOException ioe = null;
        while (doTry) {
            Object object = this.lock;
            synchronized (object) {
                block10: {
                    try {
                        this.getOrCreateChannel().getConnection();
                        doTry = false;
                    }
                    catch (IOException e) {
                        ioe = e;
                        if (this.strategy == null) break block10;
                        StreamUtils.safeClose((Closeable)this.strategy);
                        this.strategy = null;
                    }
                }
                this.lock.notifyAll();
            }
            if (ioe == null) continue;
            if (ioe.getCause() != null && ioe.getCause() instanceof SaslException) {
                throw new CommandLineException("Failed to establish connection", ioe);
            }
            if (System.currentTimeMillis() - start > timeoutMillis) {
                throw new CommandLineException("Failed to establish connection in " + (System.currentTimeMillis() - start) + "ms", ioe);
            }
            ioe = null;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
            }
        }
    }

    static {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("cli-remoting"), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
        executorService = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
        executorService.allowCoreThreadTimeOut(true);
        try {
            endpoint = Remoting.createEndpoint((String)"cli-client", (OptionMap)OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true));
            endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
            endpoint.addConnectionProvider("remoting", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
            endpoint.addConnectionProvider("http-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
            endpoint.addConnectionProvider("https-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.TRUE));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create remoting endpoint", e);
        }
        CliShutdownHook.add(new CliShutdownHook.Handler(){

            @Override
            public void shutdown() {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    endpoint.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private final class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ManagementClientChannelStrategy originalStrategy;

        private ChannelCloseHandler() {
        }

        void setOriginalStrategy(ManagementClientChannelStrategy strategy) {
            if (this.originalStrategy != null) {
                throw new IllegalArgumentException("The strategy has already been initialized.");
            }
            this.originalStrategy = strategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClose(Channel closed, IOException exception) {
            if (CLIModelControllerClient.this.state.get() == 0) {
                return;
            }
            if (CLIModelControllerClient.this.state.compareAndSet(1, 3)) {
                return;
            }
            Object object = CLIModelControllerClient.this.lock;
            synchronized (object) {
                if (CLIModelControllerClient.this.strategy != null) {
                    if (CLIModelControllerClient.this.strategy != this.originalStrategy) {
                        new Exception("Channel close handler " + CLIModelControllerClient.this.strategy + " " + this.originalStrategy).printStackTrace();
                    }
                    CLIModelControllerClient.this.strategy = null;
                    CLIModelControllerClient.this.closeHandler.handleClose();
                }
                CLIModelControllerClient.this.channelAssociation.handleChannelClosed(closed, exception);
                CLIModelControllerClient.this.lock.notifyAll();
            }
            closed.getConnection().addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                public void handleClose(Connection closed, IOException exception) {
                    StreamUtils.safeClose((Closeable)ChannelCloseHandler.this.originalStrategy);
                }
            });
        }
    }
}

