/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<K, V> {
    private static final Logger LOGGER = FacesLogger.UTIL.getLogger();
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final Factory<K, V> factory;

    public Cache(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        Object result = this.cache.get(key);
        if (result == null) {
            try {
                result = this.factory.newInstance(key);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            V oldResult = this.cache.putIfAbsent(key, result);
            if (oldResult != null) {
                result = oldResult;
            }
        }
        return result;
    }

    public V remove(K key) {
        return this.cache.remove(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<K, V> {
        public V newInstance(K var1) throws InterruptedException;
    }
}

