/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicAdd;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicControlHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicRemove;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicUpdateJndiHandler;

public class JMSTopicDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES, CommonAttributes.LEGACY_ENTRIES};
    private static AttributeDefinition[] DEPLOYMENT_ATTRIBUTES = new AttributeDefinition[]{((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(CommonAttributes.DESTINATION_ENTRIES).setStorageRuntime()).build(), ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(CommonAttributes.LEGACY_ENTRIES).setStorageRuntime()).build()};
    static final AttributeDefinition TOPIC_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"topic-address", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{TOPIC_ADDRESS, CommonAttributes.TEMPORARY};
    static final AttributeDefinition DURABLE_MESSAGE_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"durable-message-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition NON_DURABLE_MESSAGE_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"non-durable-message-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition DURABLE_SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition NON_DURABLE_SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"non-durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.MESSAGE_COUNT, DURABLE_MESSAGE_COUNT, NON_DURABLE_MESSAGE_COUNT, SUBSCRIPTION_COUNT, DURABLE_SUBSCRIPTION_COUNT, NON_DURABLE_SUBSCRIPTION_COUNT};
    private final boolean deployed;
    public static final JMSTopicDefinition INSTANCE = new JMSTopicDefinition(false);
    public static final JMSTopicDefinition DEPLOYMENT_INSTANCE = new JMSTopicDefinition(true);

    private JMSTopicDefinition(boolean deployed) {
        super(MessagingExtension.JMS_TOPIC_PATH, MessagingExtension.getResourceDescriptionResolver("jms-topic"), (OperationStepHandler)(deployed ? null : JMSTopicAdd.INSTANCE), (OperationStepHandler)(deployed ? null : JMSTopicRemove.INSTANCE));
        this.deployed = deployed;
    }

    public Collection<AttributeDefinition> getAttributes() {
        if (this.deployed) {
            return Arrays.asList(DEPLOYMENT_ATTRIBUTES);
        }
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            if (attr == CommonAttributes.DESTINATION_ENTRIES || attr == CommonAttributes.LEGACY_ENTRIES) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
                continue;
            }
            registry.registerReadOnlyAttribute(attr, null);
        }
        for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition metric : METRICS) {
            registry.registerMetric(metric, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (!this.deployed) {
            JMSTopicUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        JMSTopicControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Arrays.asList(MessagingExtension.JMS_TOPIC_ACCESS_CONSTRAINT);
    }
}

