/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl.service.factory;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class XercesSchemaValidationUtils {
    private XSImplementation impl;

    XercesSchemaValidationUtils() {
        DOMXSImplementationSourceImpl source = new DOMXSImplementationSourceImpl();
        this.impl = (XSImplementation)source.getDOMImplementation("XS-Loader");
    }

    void tryToParseSchemas(XmlSchemaCollection collection, DOMErrorHandler handler) throws XmlSchemaSerializer.XmlSchemaSerializerException, TransformerException {
        ArrayList<DOMLSInput> inputs = new ArrayList<DOMLSInput>();
        final HashMap<String, DOMLSInput> resolverMap = new HashMap<String, DOMLSInput>();
        for (XmlSchema schema : collection.getXmlSchemas()) {
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            Document document = new XmlSchemaSerializer().serializeSchema(schema, false)[0];
            DOMLSInput input = new DOMLSInput(document, schema.getTargetNamespace());
            resolverMap.put(schema.getTargetNamespace(), input);
            inputs.add(input);
        }
        XSLoader schemaLoader = this.impl.createXSLoader(null);
        schemaLoader.getConfig().setParameter("validate", Boolean.TRUE);
        schemaLoader.getConfig().setParameter("error-handler", handler);
        schemaLoader.getConfig().setParameter("resource-resolver", new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                return (LSInput)resolverMap.get(namespaceURI);
            }
        });
        schemaLoader.loadInputList((LSInputList)new ListLSInput(inputs));
    }

    class DOMLSInput
    implements LSInput {
        private String systemId;
        private String data;

        DOMLSInput(Document doc, String systemId) throws TransformerException {
            this.systemId = systemId;
            this.data = StaxUtils.toString((Document)doc);
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return "utf-8";
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getStringData() {
            return this.data;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public void setSystemId(String systemId) {
        }
    }

    private static final class ListLSInput
    extends ArrayList
    implements LSInputList {
        private static final long serialVersionUID = 1L;

        private ListLSInput(List inputs) {
            super(inputs);
        }

        public int getLength() {
            return this.size();
        }

        public LSInput item(int index) {
            return (LSInput)this.get(index);
        }
    }
}

