/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionProducerCreditsFailMessage
extends PacketImpl {
    private int credits;
    private SimpleString address;

    public SessionProducerCreditsFailMessage(int credits, SimpleString address) {
        super((byte)82);
        this.credits = credits;
        this.address = address;
    }

    public SessionProducerCreditsFailMessage() {
        super((byte)82);
    }

    public int getCredits() {
        return this.credits;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.credits);
        buffer.writeSimpleString(this.address);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.credits = buffer.readInt();
        this.address = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.credits;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionProducerCreditsFailMessage)) {
            return false;
        }
        SessionProducerCreditsFailMessage other = (SessionProducerCreditsFailMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.credits == other.credits;
    }
}

