/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.AbstractParser;
import org.jboss.jca.common.metadata.resourceadapter.AdminObjectImpl;
import org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.resourceadapter.WorkManagerImpl;
import org.jboss.jca.common.metadata.resourceadapter.WorkManagerSecurityImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected AdminObject parseAdminObjects(XMLStreamReader reader) throws XMLStreamException, ParserException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String poolName = null;
        int attributeSize = reader.getAttributeCount();
        block14: for (int i = 0; i < attributeSize; ++i) {
            AdminObject.Attribute attribute = AdminObject.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block14;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block14;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block14;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block7 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.ADMIN_OBJECT) {
                        return new AdminObjectImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext);
                    }
                    if (AdminObject.Tag.forName((String)reader.getLocalName()) != AdminObject.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (AdminObject.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperty(configProperties, reader);
                            break block7;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManager parseWorkManager(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        WorkManagerSecurity security = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.WORKMANAGER) {
                        return new WorkManagerImpl(security);
                    }
                    if (Activation.Tag.forName((String)reader.getLocalName()) != Activation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManager.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY: {
                            security = this.parseWorkManagerSecurity(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManagerSecurity parseWorkManagerSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean mappingRequired = false;
        String domain = null;
        String defaultPrincipal = null;
        ArrayList<String> defaultGroups = null;
        HashMap<String, String> userMappings = null;
        HashMap<String, String> groupMappings = null;
        boolean userMappingEnabled = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (WorkManager.Tag.forName((String)reader.getLocalName()) == WorkManager.Tag.SECURITY) {
                        return new WorkManagerSecurityImpl(mappingRequired, domain, defaultPrincipal, defaultGroups, userMappings, groupMappings);
                    }
                    if (WorkManagerSecurity.Tag.forName((String)reader.getLocalName()) != WorkManagerSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManagerSecurity.Tag.forName((String)reader.getLocalName())) {
                        case DEFAULT_GROUPS: 
                        case MAPPINGS: {
                            break block0;
                        }
                        case MAPPING_REQUIRED: {
                            mappingRequired = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case DOMAIN: {
                            domain = this.elementAsString(reader);
                            break block0;
                        }
                        case DEFAULT_PRINCIPAL: {
                            defaultPrincipal = this.elementAsString(reader);
                            break block0;
                        }
                        case GROUP: {
                            if (defaultGroups == null) {
                                defaultGroups = new ArrayList<String>(1);
                            }
                            defaultGroups.add(this.elementAsString(reader));
                            break block0;
                        }
                        case USERS: {
                            userMappingEnabled = true;
                            break block0;
                        }
                        case GROUPS: {
                            userMappingEnabled = false;
                            break block0;
                        }
                        case MAP: {
                            String to;
                            String from;
                            if (userMappingEnabled) {
                                if (userMappings == null) {
                                    userMappings = new HashMap<String, String>();
                                }
                                if ((from = this.attributeAsString(reader, WorkManagerSecurity.Attribute.FROM.getLocalName())) == null || from.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                                }
                                to = this.attributeAsString(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                                if (to == null || to.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                                }
                                userMappings.put(from, to);
                                break block0;
                            }
                            if (groupMappings == null) {
                                groupMappings = new HashMap<String, String>();
                            }
                            if ((from = this.attributeAsString(reader, WorkManagerSecurity.Attribute.FROM.getLocalName())) == null || from.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                            }
                            to = this.attributeAsString(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                            if (to == null || to.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                            }
                            groupMappings.put(from, to);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected ConnectionDefinition parseConnectionDefinitions(XMLStreamReader reader, Boolean isXA) throws XMLStreamException, ParserException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        Security security = null;
        TimeOut timeOut = null;
        Validation validation = null;
        XaPool pool = null;
        Recovery recovery = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String poolName = null;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean sharable = Defaults.SHARABLE;
        Boolean enlistment = Defaults.ENLISTMENT;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        int attributeSize = reader.getAttributeCount();
        if (isXA == null) {
            isXA = Boolean.FALSE;
        }
        block25: for (int i = 0; i < attributeSize; ++i) {
            ConnectionDefinition.Attribute attribute = ConnectionDefinition.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block25;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case CLASS_NAME: {
                    className = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block25;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block25;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block25;
                }
                case SHARABLE: {
                    sharable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SHARABLE);
                    continue block25;
                }
                case ENLISTMENT: {
                    enlistment = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENLISTMENT);
                    continue block25;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block25;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block25;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.CONNECTION_DEFINITION) {
                        return new ConnectionDefinitionImpl(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, sharable, enlistment, connectable, tracking, (Pool)pool, timeOut, validation, security, recovery, isXA);
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ConnectionDefinition.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperty(configProperties, reader);
                            break block12;
                        }
                        case SECURITY: {
                            security = this.parseSecuritySettings(reader);
                            break block12;
                        }
                        case TIMEOUT: {
                            timeOut = this.parseTimeOut(reader, isXA);
                            break block12;
                        }
                        case VALIDATION: {
                            validation = this.parseValidation(reader);
                            break block12;
                        }
                        case XA_POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXA = Boolean.TRUE;
                            break block12;
                        }
                        case POOL: {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block12;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

