/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet.services;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobXmlResolver;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.jberet.BatchEnvironmentFactory;
import org.wildfly.jberet.WildFlyArtifactFactory;
import org.wildfly.jberet._private.WildFlyBatchLogger;
import org.wildfly.jberet.services.ClassLoaderContextHandle;
import org.wildfly.jberet.services.ContextHandle;
import org.wildfly.jberet.services.NamespaceContextHandle;
import org.wildfly.jberet.services.SecurityContextHandle;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentService
implements Service<BatchEnvironment> {
    private static final Properties PROPS = new Properties();
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceInjector = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerInjector = new InjectedValue();
    private final InjectedValue<JobXmlResolver> jobXmlResolverInjector = new InjectedValue();
    private final InjectedValue<RequestController> requestControllerInjector = new InjectedValue();
    private final JobRepository jobRepository;
    private final ClassLoader classLoader;
    private final String deploymentName;
    private BatchEnvironment batchEnvironment = null;
    private ControlPoint controlPoint;

    public BatchEnvironmentService(ClassLoader classLoader, JobRepository jobRepository, String deploymentName) {
        this.classLoader = classLoader;
        this.jobRepository = jobRepository;
        this.deploymentName = deploymentName;
    }

    public synchronized void start(StartContext context) throws StartException {
        WildFlyBatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        RequestController requestController = (RequestController)this.requestControllerInjector.getOptionalValue();
        this.controlPoint = requestController != null ? requestController.getControlPoint(this.deploymentName, "batch-executor-service") : null;
        WildFlyBatchEnvironment batchEnvironment = new WildFlyBatchEnvironment((BeanManager)this.beanManagerInjector.getOptionalValue(), (ExecutorService)this.executorServiceInjector.getValue(), (TransactionManager)this.transactionManagerInjector.getValue(), (JobXmlResolver)this.jobXmlResolverInjector.getValue(), this.controlPoint);
        BatchEnvironmentFactory.getInstance().add(this.classLoader, batchEnvironment);
        this.batchEnvironment = batchEnvironment;
    }

    public synchronized void stop(StopContext context) {
        WildFlyBatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        BatchEnvironmentFactory.getInstance().remove(this.classLoader);
        this.batchEnvironment = null;
        if (this.controlPoint != null) {
            ((RequestController)this.requestControllerInjector.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public synchronized BatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceInjector;
    }

    public InjectedValue<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjector;
    }

    public InjectedValue<JobXmlResolver> getJobXmlResolverInjector() {
        return this.jobXmlResolverInjector;
    }

    public InjectedValue<RequestController> getRequestControllerInjector() {
        return this.requestControllerInjector;
    }

    private class WildFlyBatchEnvironment
    implements BatchEnvironment {
        private final ArtifactFactory artifactFactory;
        private final ExecutorService executorService;
        private final TransactionManager transactionManager;
        private final JobXmlResolver jobXmlResolver;
        private final ControlPoint controlPoint;

        WildFlyBatchEnvironment(BeanManager beanManager, ExecutorService executorService, TransactionManager transactionManager, JobXmlResolver jobXmlResolver, ControlPoint controlPoint) {
            this.jobXmlResolver = jobXmlResolver;
            this.artifactFactory = new WildFlyArtifactFactory(beanManager);
            this.executorService = executorService;
            this.transactionManager = transactionManager;
            this.controlPoint = controlPoint;
        }

        public ClassLoader getClassLoader() {
            return BatchEnvironmentService.this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public void submitTask(final Runnable task) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ContextHandle contextHandle = WildFlyBatchEnvironment.this.createContextHandle();
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        task.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            };
            if (this.controlPoint == null) {
                this.executorService.submit(r);
            } else {
                this.controlPoint.queueTask(r, (Executor)this.executorService, -1L, null, false);
            }
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public JobRepository getJobRepository() {
            return BatchEnvironmentService.this.jobRepository;
        }

        public JobXmlResolver getJobXmlResolver() {
            return this.jobXmlResolver;
        }

        @Deprecated
        public Properties getBatchConfigurationProperties() {
            return PROPS;
        }

        private ContextHandle createContextHandle() {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(BatchEnvironmentService.this.classLoader) : new ClassLoaderContextHandle(tccl);
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(), new SecurityContextHandle());
        }
    }
}

