/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;

public interface Configuration {
    public String getName();

    public Configuration setName(String var1);

    public boolean isClustered();

    public boolean isPersistDeliveryCountBeforeDelivery();

    public Configuration setPersistDeliveryCountBeforeDelivery(boolean var1);

    public boolean isPersistenceEnabled();

    public Configuration setPersistenceEnabled(boolean var1);

    public Map<String, ResourceLimitSettings> getResourceLimitSettings();

    public Configuration setResourceLimitSettings(Map<String, ResourceLimitSettings> var1);

    public Configuration addResourceLimitSettings(ResourceLimitSettings var1);

    public long getFileDeployerScanPeriod();

    public Configuration setFileDeployerScanPeriod(long var1);

    public int getThreadPoolMaxSize();

    public Configuration setThreadPoolMaxSize(int var1);

    public int getScheduledThreadPoolMaxSize();

    public Configuration setScheduledThreadPoolMaxSize(int var1);

    public long getSecurityInvalidationInterval();

    public Configuration setSecurityInvalidationInterval(long var1);

    public boolean isSecurityEnabled();

    public Configuration setSecurityEnabled(boolean var1);

    public boolean isGracefulShutdownEnabled();

    public Configuration setGracefulShutdownEnabled(boolean var1);

    public long getGracefulShutdownTimeout();

    public Configuration setGracefulShutdownTimeout(long var1);

    public boolean isJMXManagementEnabled();

    public Configuration setJMXManagementEnabled(boolean var1);

    public String getJMXDomain();

    public Configuration setJMXDomain(String var1);

    public List<String> getIncomingInterceptorClassNames();

    public List<String> getOutgoingInterceptorClassNames();

    public Configuration setIncomingInterceptorClassNames(List<String> var1);

    public Configuration setOutgoingInterceptorClassNames(List<String> var1);

    public long getConnectionTTLOverride();

    public Configuration setConnectionTTLOverride(long var1);

    public boolean isAsyncConnectionExecutionEnabled();

    public Configuration setEnabledAsyncConnectionExecution(boolean var1);

    public Set<TransportConfiguration> getAcceptorConfigurations();

    public Configuration setAcceptorConfigurations(Set<TransportConfiguration> var1);

    public Configuration addAcceptorConfiguration(TransportConfiguration var1);

    public Configuration clearAcceptorConfigurations();

    public Map<String, TransportConfiguration> getConnectorConfigurations();

    public Configuration setConnectorConfigurations(Map<String, TransportConfiguration> var1);

    public Configuration addConnectorConfiguration(String var1, TransportConfiguration var2);

    public List<BroadcastGroupConfiguration> getBroadcastGroupConfigurations();

    public Configuration setBroadcastGroupConfigurations(List<BroadcastGroupConfiguration> var1);

    public Configuration addBroadcastGroupConfiguration(BroadcastGroupConfiguration var1);

    public Map<String, DiscoveryGroupConfiguration> getDiscoveryGroupConfigurations();

    public Configuration setDiscoveryGroupConfigurations(Map<String, DiscoveryGroupConfiguration> var1);

    public Configuration addDiscoveryGroupConfiguration(String var1, DiscoveryGroupConfiguration var2);

    public GroupingHandlerConfiguration getGroupingHandlerConfiguration();

    public Configuration setGroupingHandlerConfiguration(GroupingHandlerConfiguration var1);

    public List<BridgeConfiguration> getBridgeConfigurations();

    public Configuration setBridgeConfigurations(List<BridgeConfiguration> var1);

    public List<DivertConfiguration> getDivertConfigurations();

    public Configuration setDivertConfigurations(List<DivertConfiguration> var1);

    public List<ClusterConnectionConfiguration> getClusterConfigurations();

    public Configuration setClusterConfigurations(List<ClusterConnectionConfiguration> var1);

    public Configuration addClusterConfiguration(ClusterConnectionConfiguration var1);

    public Configuration clearClusterConfigurations();

    public List<CoreQueueConfiguration> getQueueConfigurations();

    public Configuration setQueueConfigurations(List<CoreQueueConfiguration> var1);

    public Configuration addQueueConfiguration(CoreQueueConfiguration var1);

    public SimpleString getManagementAddress();

    public Configuration setManagementAddress(SimpleString var1);

    public SimpleString getManagementNotificationAddress();

    public Configuration setManagementNotificationAddress(SimpleString var1);

    public String getClusterUser();

    public Configuration setClusterUser(String var1);

    public String getClusterPassword();

    public Configuration setClusterPassword(String var1);

    public int getIDCacheSize();

    public Configuration setIDCacheSize(int var1);

    public boolean isPersistIDCache();

    public Configuration setPersistIDCache(boolean var1);

    public String getBindingsDirectory();

    public Configuration setBindingsDirectory(String var1);

    public int getPageMaxConcurrentIO();

    public Configuration setPageMaxConcurrentIO(int var1);

    public String getJournalDirectory();

    public Configuration setJournalDirectory(String var1);

    public JournalType getJournalType();

    public Configuration setJournalType(JournalType var1);

    public boolean isJournalSyncTransactional();

    public Configuration setJournalSyncTransactional(boolean var1);

    public boolean isJournalSyncNonTransactional();

    public Configuration setJournalSyncNonTransactional(boolean var1);

    public int getJournalFileSize();

    public Configuration setJournalFileSize(int var1);

    public int getJournalCompactMinFiles();

    public Configuration setJournalCompactMinFiles(int var1);

    public int getJournalCompactPercentage();

    public Configuration setJournalCompactPercentage(int var1);

    public int getJournalMinFiles();

    public Configuration setJournalMinFiles(int var1);

    public int getJournalMaxIO_AIO();

    public Configuration setJournalMaxIO_AIO(int var1);

    public int getJournalBufferTimeout_AIO();

    public Configuration setJournalBufferTimeout_AIO(int var1);

    public int getJournalBufferSize_AIO();

    public Configuration setJournalBufferSize_AIO(int var1);

    public int getJournalMaxIO_NIO();

    public Configuration setJournalMaxIO_NIO(int var1);

    public int getJournalBufferTimeout_NIO();

    public Configuration setJournalBufferTimeout_NIO(int var1);

    public int getJournalBufferSize_NIO();

    public Configuration setJournalBufferSize_NIO(int var1);

    public boolean isCreateBindingsDir();

    public Configuration setCreateBindingsDir(boolean var1);

    public boolean isCreateJournalDir();

    public Configuration setCreateJournalDir(boolean var1);

    public boolean isLogJournalWriteRate();

    public Configuration setLogJournalWriteRate(boolean var1);

    public int getJournalPerfBlastPages();

    public Configuration setJournalPerfBlastPages(int var1);

    public long getServerDumpInterval();

    public Configuration setServerDumpInterval(long var1);

    public int getMemoryWarningThreshold();

    public Configuration setMemoryWarningThreshold(int var1);

    public long getMemoryMeasureInterval();

    public Configuration setMemoryMeasureInterval(long var1);

    public boolean isRunSyncSpeedTest();

    public Configuration setRunSyncSpeedTest(boolean var1);

    public String getPagingDirectory();

    public Configuration setPagingDirectory(String var1);

    public String getLargeMessagesDirectory();

    public Configuration setLargeMessagesDirectory(String var1);

    public boolean isWildcardRoutingEnabled();

    public Configuration setWildcardRoutingEnabled(boolean var1);

    public long getTransactionTimeout();

    public Configuration setTransactionTimeout(long var1);

    public boolean isMessageCounterEnabled();

    public Configuration setMessageCounterEnabled(boolean var1);

    public long getMessageCounterSamplePeriod();

    public Configuration setMessageCounterSamplePeriod(long var1);

    public int getMessageCounterMaxDayHistory();

    public Configuration setMessageCounterMaxDayHistory(int var1);

    public long getTransactionTimeoutScanPeriod();

    public Configuration setTransactionTimeoutScanPeriod(long var1);

    public long getMessageExpiryScanPeriod();

    public Configuration setMessageExpiryScanPeriod(long var1);

    public int getMessageExpiryThreadPriority();

    public Configuration setMessageExpiryThreadPriority(int var1);

    public Map<String, AddressSettings> getAddressesSettings();

    public Configuration setAddressesSettings(Map<String, AddressSettings> var1);

    public Configuration addAddressesSetting(String var1, AddressSettings var2);

    public Configuration setSecurityRoles(Map<String, Set<Role>> var1);

    public Map<String, Set<Role>> getSecurityRoles();

    public Configuration setConnectorServiceConfigurations(List<ConnectorServiceConfiguration> var1);

    public Configuration addConnectorServiceConfiguration(ConnectorServiceConfiguration var1);

    public List<ConnectorServiceConfiguration> getConnectorServiceConfigurations();

    public Configuration setPasswordCodec(String var1);

    public String getPasswordCodec();

    public Configuration setMaskPassword(boolean var1);

    public boolean isMaskPassword();

    public Configuration setResolveProtocols(boolean var1);

    public boolean isResolveProtocols();

    public Configuration copy() throws Exception;

    public Configuration setJournalLockAcquisitionTimeout(long var1);

    public long getJournalLockAcquisitionTimeout();

    public HAPolicyConfiguration getHAPolicyConfiguration();

    public Configuration setHAPolicyConfiguration(HAPolicyConfiguration var1);
}

