/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.jboss.threads.DirectExecutor;

class PrivilegedExecutor
implements DirectExecutor {
    private final DirectExecutor delegate;
    private final AccessControlContext context;

    PrivilegedExecutor(DirectExecutor delegate, AccessControlContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    PrivilegedExecutor(DirectExecutor delegate, Class<?> targetClass) throws SecurityException {
        this.delegate = delegate;
        this.context = new AccessControlContext(new ProtectionDomain[]{targetClass.getProtectionDomain()});
    }

    @Override
    public void execute(final Runnable command) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PrivilegedExecutor.this.delegate.execute(command);
                    return null;
                }
            }, this.context);
        } else {
            this.delegate.execute(command);
        }
    }

    public String toString() {
        return String.format("%s (for %s) -> %s", super.toString(), this.context, this.delegate);
    }
}

