/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.permission;

import java.security.Permission;

public final class RunAsPrincipalPermission
extends Permission {
    private static final long serialVersionUID = -3361334389433669815L;

    public RunAsPrincipalPermission(String name, String securityDomainName) {
        super(RunAsPrincipalPermission.compileName(name, securityDomainName));
    }

    private static String compileName(String name, String securityDomainName) {
        if (securityDomainName.indexOf(58) != -1) {
            throw new IllegalArgumentException("Security domain name is invalid");
        }
        return securityDomainName + ":" + name;
    }

    @Override
    public boolean implies(Permission permission) {
        return this.equals(permission);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RunAsPrincipalPermission && this.equals((RunAsPrincipalPermission)obj);
    }

    public boolean equals(RunAsPrincipalPermission perm) {
        return perm != null && perm.getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }
}

