/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.security.password.PasswordUtil;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.SunUnixMD5CryptPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.HashedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SunUnixMD5CryptPasswordSpec;

final class SunUnixMD5CryptPasswordImpl
extends AbstractPasswordImpl
implements SunUnixMD5CryptPassword {
    private static final long serialVersionUID = 2894797156094167807L;
    static final String MD5 = "MD5";
    static final byte[] MAGIC_BYTES = "$md5$".getBytes(StandardCharsets.UTF_8);
    static final byte[] MAGIC_BYTES_WITH_ROUNDS = "$md5,rounds=".getBytes(StandardCharsets.UTF_8);
    static final byte[] SEPARATOR_BYTES = "$".getBytes(StandardCharsets.UTF_8);
    static final int BASIC_ROUND_COUNT = 4096;
    private final String algorithm;
    private final byte[] hash;
    private final byte[] salt;
    private final int iterationCount;
    private static final String HAMLET_EXCERPT = "To be, or not to be,--that is the question:--\nWhether 'tis nobler in the mind to suffer\nThe slings and arrows of outrageous fortune\nOr to take arms against a sea of troubles,\nAnd by opposing end them?--To die,--to sleep,--\nNo more; and by a sleep to say we end\nThe heartache, and the thousand natural shocks\nThat flesh is heir to,--'tis a consummation\nDevoutly to be wish'd. To die,--to sleep;--\nTo sleep! perchance to dream:--ay, there's the rub;\nFor in that sleep of death what dreams may come,\nWhen we have shuffled off this mortal coil,\nMust give us pause: there's the respect\nThat makes calamity of so long life;\nFor who would bear the whips and scorns of time,\nThe oppressor's wrong, the proud man's contumely,\nThe pangs of despis'd love, the law's delay,\nThe insolence of office, and the spurns\nThat patient merit of the unworthy takes,\nWhen he himself might his quietus make\nWith a bare bodkin? who would these fardels bear,\nTo grunt and sweat under a weary life,\nBut that the dread of something after death,--\nThe undiscover'd country, from whose bourn\nNo traveller returns,--puzzles the will,\nAnd makes us rather bear those ills we have\nThan fly to others that we know not of?\nThus conscience does make cowards of us all;\nAnd thus the native hue of resolution\nIs sicklied o'er with the pale cast of thought;\nAnd enterprises of great pith and moment,\nWith this regard, their currents turn awry,\nAnd lose the name of action.--Soft you now!\nThe fair Ophelia!--Nymph, in thy orisons\nBe all my sins remember'd.\n\u0000";

    SunUnixMD5CryptPasswordImpl(String algorithm, byte[] clonedHash, byte[] clonedSalt, int iterationCount) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm is null");
        }
        if (!algorithm.equals("sun-crypt-md5") && !algorithm.equals("sun-crypt-md5-bare-salt")) {
            throw new IllegalArgumentException("Unsupported algorithm given");
        }
        this.algorithm = algorithm;
        this.hash = clonedHash;
        this.salt = clonedSalt;
        this.iterationCount = iterationCount;
    }

    SunUnixMD5CryptPasswordImpl(SunUnixMD5CryptPassword password) {
        this(password.getAlgorithm(), (byte[])password.getHash().clone(), (byte[])password.getSalt().clone(), password.getIterationCount());
    }

    SunUnixMD5CryptPasswordImpl(SunUnixMD5CryptPasswordSpec spec) {
        this(spec.getAlgorithm(), (byte[])spec.getHash().clone(), (byte[])spec.getSalt().clone(), spec.getIterationCount());
    }

    SunUnixMD5CryptPasswordImpl(ClearPasswordSpec spec) throws NoSuchAlgorithmException {
        this.algorithm = "sun-crypt-md5";
        this.salt = PasswordUtil.generateRandomSalt(8);
        this.iterationCount = 5500;
        this.hash = SunUnixMD5CryptPasswordImpl.sunMD5Crypt(this.algorithm, SunUnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(spec.getEncodedPassword()), this.salt, this.iterationCount);
    }

    SunUnixMD5CryptPasswordImpl(String algorithm, EncryptablePasswordSpec spec) throws NoSuchAlgorithmException {
        this(algorithm, spec.getPassword(), (HashedPasswordAlgorithmSpec)spec.getAlgorithmParameterSpec());
    }

    private SunUnixMD5CryptPasswordImpl(String algorithm, char[] password, HashedPasswordAlgorithmSpec spec) throws NoSuchAlgorithmException {
        this(algorithm, password, spec.getSalt() == null ? PasswordUtil.generateRandomSalt(8) : (byte[])spec.getSalt().clone(), spec.getIterationCount());
    }

    private SunUnixMD5CryptPasswordImpl(String algorithm, char[] password, byte[] clonedSalt, int iterationCount) throws NoSuchAlgorithmException {
        this(algorithm, SunUnixMD5CryptPasswordImpl.sunMD5Crypt(algorithm, SunUnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(password), clonedSalt, iterationCount), clonedSalt, iterationCount);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(SunUnixMD5CryptPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new SunUnixMD5CryptPasswordSpec(this.getAlgorithm(), this.getHash(), this.getSalt(), this.getIterationCount())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        byte[] test;
        try {
            test = SunUnixMD5CryptPasswordImpl.sunMD5Crypt(this.getAlgorithm(), SunUnixMD5CryptPasswordImpl.getNormalizedPasswordBytes(guess), this.getSalt(), this.getIterationCount());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Cannot verify password", e);
        }
        return Arrays.equals(this.getHash(), test);
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(SunUnixMD5CryptPasswordSpec.class);
    }

    static byte[] sunMD5Crypt(String algorithm, byte[] password, byte[] salt, int iterationCount) throws NoSuchAlgorithmException {
        MessageDigest digest = SunUnixMD5CryptPasswordImpl.getMD5MessageDigest();
        digest.update(password);
        if (iterationCount == 0) {
            digest.update(MAGIC_BYTES);
        } else {
            digest.update(MAGIC_BYTES_WITH_ROUNDS);
            digest.update(Integer.toString(iterationCount).getBytes(StandardCharsets.UTF_8));
            digest.update(SEPARATOR_BYTES);
        }
        digest.update(salt);
        if (algorithm.equals("sun-crypt-md5")) {
            digest.update(SEPARATOR_BYTES);
        }
        byte[] result = digest.digest();
        int actualIterationCount = 4096 + iterationCount;
        int[] unsignedResult = new int[16];
        for (int round = 0; round < actualIterationCount; ++round) {
            int i;
            digest.reset();
            digest.update(result, 0, 16);
            for (i = 0; i < 16; ++i) {
                unsignedResult[i] = result[i] & 0xFF;
            }
            int x = 0;
            int y = 0;
            for (i = 0; i < 8; ++i) {
                int a = unsignedResult[i];
                int b = unsignedResult[i + 3];
                int v = unsignedResult[a >> b % 5 & 0xF] >> (b >> (a & 7) & 1);
                x |= SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, v) << i;
                a = unsignedResult[i + 8];
                b = unsignedResult[i + 11 & 0xF];
                v = unsignedResult[a >> b % 5 & 0xF] >> (b >> (a & 7) & 1);
                y |= SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, v) << i;
            }
            x = x >> SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, round) & 0x7F;
            y = y >> SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, round + 64) & 0x7F;
            int muffetCoinToss = SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, x) ^ SunUnixMD5CryptPasswordImpl.getDigestBit(unsignedResult, y);
            if (muffetCoinToss == 1) {
                digest.update(HAMLET_EXCERPT.getBytes(StandardCharsets.UTF_8));
            }
            digest.update(Integer.toString(round).getBytes(StandardCharsets.US_ASCII));
            result = digest.digest();
        }
        Arrays.fill(unsignedResult, 0);
        return result;
    }

    private static int getDigestBit(int[] unsignedResult, int bitPosition) {
        return unsignedResult[bitPosition >> 3 & 0xF] >> (bitPosition & 7) & 1;
    }

    private static MessageDigest getMD5MessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(MD5);
    }
}

