/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;

public abstract class TrustedAuthority {
    public static final int AUTHORITY_NAME = 0;
    public static final int ISSUER_NAME_HASH = 1;
    public static final int ISSUER_KEY_HASH = 2;
    public static final int AUTHORITY_CERTIFICATE = 3;
    public static final int PKCS_15_KEY_HASH = 4;
    private final int type;

    TrustedAuthority(int type) {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)");
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public abstract Object getIdentifier();

    public static final class PKCS15KeyHashTrustedAuthority
    extends HashTrustedAuthority {
        public PKCS15KeyHashTrustedAuthority(byte[] hash) {
            super(4, hash);
        }

        public PKCS15KeyHashTrustedAuthority(String hash) {
            super(4, hash);
        }
    }

    public static final class IssuerKeyHashTrustedAuthority
    extends HashTrustedAuthority {
        public IssuerKeyHashTrustedAuthority(byte[] hash) {
            super(2, hash);
        }

        public IssuerKeyHashTrustedAuthority(String hash) {
            super(2, hash);
        }
    }

    public static final class IssuerNameHashTrustedAuthority
    extends HashTrustedAuthority {
        public IssuerNameHashTrustedAuthority(byte[] hash) {
            super(1, hash);
        }

        public IssuerNameHashTrustedAuthority(String hash) {
            super(1, hash);
        }
    }

    public static abstract class HashTrustedAuthority
    extends TrustedAuthority {
        private final byte[] hash;

        HashTrustedAuthority(int type, byte[] hash) {
            super(type);
            this.hash = hash;
        }

        HashTrustedAuthority(int type, String hash) {
            this(type, hash.getBytes(StandardCharsets.UTF_8));
        }

        public byte[] getIdentifier() {
            return (byte[])this.hash.clone();
        }
    }

    public static final class CertificateTrustedAuthority
    extends TrustedAuthority {
        private final X509Certificate cert;

        public CertificateTrustedAuthority(X509Certificate cert) {
            super(3);
            this.cert = cert;
        }

        @Override
        public X509Certificate getIdentifier() {
            return this.cert;
        }
    }

    public static final class NameTrustedAuthority
    extends TrustedAuthority {
        private final String name;

        public NameTrustedAuthority(String name) {
            super(0);
            this.name = name;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

