/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.SSLQueryCallbackHandler;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class SSLSaslServerFactory
extends AbstractDelegatingSaslServerFactory
implements SaslServerFactory {
    private final SSLContext sslContext;
    private final SSLSocket sslSocket;
    private final SSLEngine sslEngine;

    public SSLSaslServerFactory(SaslServerFactory delegate, SSLContext sslContext, SSLEngine sslEngine) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslEngine = sslEngine;
        this.sslSocket = null;
    }

    public SSLSaslServerFactory(SaslServerFactory delegate, SSLContext sslContext, SSLSocket sslSocket) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslSocket = sslSocket;
        this.sslEngine = null;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SSLQueryCallbackHandler newHandler = this.sslEngine != null ? new SSLQueryCallbackHandler(cbh, this.sslContext, this.sslEngine) : new SSLQueryCallbackHandler(cbh, this.sslContext, this.sslSocket);
        return super.createSaslServer(mechanism, protocol, serverName, props, newHandler);
    }
}

