/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfigurationHelper;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class TransportConfigurationUtil {
    private static final Map<String, Map<String, Object>> DEFAULTS = new HashMap<String, Map<String, Object>>();
    private static final HashMap<String, Object> EMPTY_HELPER = new HashMap();

    public static Map<String, Object> getDefaults(String className) {
        if (className == null) {
            return (Map)EMPTY_HELPER.clone();
        }
        if (!DEFAULTS.containsKey(className)) {
            Object object = TransportConfigurationUtil.instantiateObject(className);
            if (object != null && object instanceof TransportConfigurationHelper) {
                DEFAULTS.put(className, ((TransportConfigurationHelper)object).getDefaults());
            } else {
                DEFAULTS.put(className, EMPTY_HELPER);
            }
        }
        return TransportConfigurationUtil.cloneDefaults(DEFAULTS.get(className));
    }

    private static Object instantiateObject(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return ClassloadingUtil.newInstanceFromClassLoader((String)className);
                }
                catch (IllegalStateException e) {
                    return null;
                }
            }
        });
    }

    private static Map<String, Object> cloneDefaults(Map<String, Object> defaults) {
        HashMap<String, Object> cloned = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            cloned.put(entry.getKey(), entry.getValue());
        }
        return cloned;
    }
}

