/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.ServerSynchronization;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.io.IOException;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;

public class ServerTransaction
extends ArjunaTransactionImple {
    protected RecoveryCoordinator _recoveryCoordinator;
    private Uid _savingUid;
    private ServerSynchronization _sync;
    private boolean _beforeCompleted;
    private int _prepState;
    private static final boolean _interposedSynch = jtsPropertyManager.getJTSEnvironmentBean().isSupportInterposedSynchronization();

    public ServerTransaction(Uid actUid, Control myParent) {
        this(actUid, myParent, null);
    }

    public ServerTransaction(Uid actUid, Control myParent, ArjunaTransactionImple parentImpl) {
        super(actUid, myParent, parentImpl);
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction::ServerTransaction ( " + actUid + ", Control myParent, " + (parentImpl != null ? parentImpl.get_uid() : Uid.nullUid()) + " )"));
        }
        this._savingUid = new Uid();
        this._sync = null;
        this._beforeCompleted = false;
        this._recoveryCoordinator = null;
        this._prepState = 6;
    }

    @Override
    public void finalize() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction.finalize ( " + this.get_uid() + " )"));
        }
        this._savingUid = null;
        if (this._sync != null) {
            this._sync.destroy();
            this._sync = null;
        }
        this._recoveryCoordinator = null;
        super.finalizeInternal();
    }

    @Override
    public String type() {
        return ServerTransaction.typeName();
    }

    @Override
    public Uid getSavingUid() {
        return this._savingUid;
    }

    public final int doPrepare() {
        int res;
        Status s;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction::doPrepare ( " + this.get_uid() + " )"));
        }
        if ((s = this.get_status()) != Status.StatusActive && s != Status.StatusMarkedRollback) {
            return 11;
        }
        this._prepState = 5;
        if (!_interposedSynch && (s != Status.StatusMarkedRollback || TxControl.isBeforeCompletionWhenRollbackOnly())) {
            try {
                this.doBeforeCompletion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this._beforeCompleted && this._sync != null) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_coordinator_syncerror("ServerTransaction.doPrepare");
            super.preventCommit();
        }
        if ((res = super.prepare(true)) == 2) {
            this.doPhase2Commit();
        }
        return res;
    }

    public final void doForget() {
        super.destroyAction();
    }

    public final int doPhase2Commit() {
        Status s;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction::doPhase2Commit ( " + this.get_uid() + " )"));
        }
        if ((s = this.get_status()) != Status.StatusPrepared) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_coordinator_txnotprepared("ServerTransaction.doPhase2Commit", Utility.stringStatus(s));
            return this.finalStatus();
        }
        super.phase2Commit(true);
        try {
            this.doAfterCompletion(this.get_status());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parentTransaction != null) {
            this.parentTransaction.removeChildAction(this);
        }
        super.destroyAction();
        ActionManager.manager().remove(this.get_uid());
        return this.finalStatus();
    }

    public final int doPhase2Abort() {
        Status s;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction::doPhase2Abort ( " + this.get_uid() + " )"));
        }
        if ((s = this.get_status()) == Status.StatusCommitted || s == Status.StatusRolledBack) {
            int status = this.finalStatus();
            switch (status) {
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    return 4;
                }
            }
            return status;
        }
        super.phase2Abort(true);
        try {
            this.doAfterCompletion(this.get_status());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parentTransaction != null) {
            this.parentTransaction.removeChildAction(this);
        }
        super.destroyAction();
        ActionManager.manager().remove(this.get_uid());
        return this.finalStatus();
    }

    public void doCommit(boolean report_heuristics) throws HeuristicHazard, SystemException {
        int outcome = super.status();
        if (outcome == 0 || outcome == 3) {
            if (!_interposedSynch && (outcome != 3 || TxControl.isBeforeCompletionWhenRollbackOnly())) {
                try {
                    this.doBeforeCompletion();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            if (this.parentTransaction != null) {
                this.parentTransaction.removeChildAction(this);
            }
            throw new INVALID_TRANSACTION(60007, CompletionStatus.COMPLETED_NO);
        }
        outcome = super.End(report_heuristics);
        try {
            this.doAfterCompletion(this.get_status());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parentTransaction != null) {
            this.parentTransaction.removeChildAction(this);
        }
        super.destroyAction();
        switch (outcome) {
            case 6: 
            case 7: 
            case 12: {
                return;
            }
            case 2: 
            case 4: 
            case 11: {
                throw new TRANSACTION_ROLLEDBACK(50001, CompletionStatus.COMPLETED_NO);
            }
        }
        throw new HeuristicHazard();
    }

    @Override
    public void rollback() throws SystemException {
        super.rollback();
    }

    @Override
    public synchronized void register_synchronization(Synchronization theSync) throws Inactive, SynchronizationUnavailable, SystemException {
        if (!this.is_top_level_transaction()) {
            throw new SynchronizationUnavailable();
        }
        if (_interposedSynch && this._sync == null) {
            this._sync = new ServerSynchronization(this);
            Coordinator realCoord = null;
            try {
                ServerControl control = (ServerControl)this.controlHandle;
                if (this.controlHandle != null) {
                    realCoord = control.originalCoordinator();
                    if (realCoord == null) {
                        throw new BAD_OPERATION(40005, CompletionStatus.COMPLETED_NO);
                    }
                } else {
                    throw new BAD_OPERATION(40005, CompletionStatus.COMPLETED_NO);
                }
                realCoord.register_synchronization(this._sync.getSynchronization());
            }
            catch (Inactive e1) {
                realCoord = null;
                throw e1;
            }
            catch (SynchronizationUnavailable e2) {
                realCoord = null;
                throw e2;
            }
            catch (SystemException e3) {
                realCoord = null;
                throw e3;
            }
            java.lang.Object var2_2 = null;
        }
        super.register_synchronization(theSync);
    }

    @Override
    public void doBeforeCompletion() throws SystemException {
        if (!this._beforeCompleted) {
            this._beforeCompleted = true;
            super.doBeforeCompletion();
        }
    }

    @Override
    public void doAfterCompletion(Status s) throws SystemException {
        super.doAfterCompletion(s);
    }

    public static String typeName() {
        return "/StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/ServerTransaction";
    }

    public final synchronized void setRecoveryCoordinator(RecoveryCoordinator recCoord) {
        this._recoveryCoordinator = recCoord;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        try {
            if (this._recoveryCoordinator != null) {
                os.packBoolean(true);
                os.packString(ORBManager.getORB().orb().object_to_string((Object)this._recoveryCoordinator));
            } else {
                os.packBoolean(false);
            }
            return super.save_state(os, ot);
        }
        catch (IOException e) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_coordinator_generror("ServerTransaction.save_state", e);
            return false;
        }
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        try {
            boolean haveRecCoord = os.unpackBoolean();
            if (haveRecCoord) {
                try {
                    String ior = os.unpackString();
                    Object objRef = ORBManager.getORB().orb().string_to_object(ior);
                    this._recoveryCoordinator = RecoveryCoordinatorHelper.narrow(objRef);
                }
                catch (Exception e) {
                    jtsLogger.i18NLogger.warn_orbspecific_interposition_coordinator_generror("ServerTransaction.restore_state", e);
                    return false;
                }
            } else {
                this._recoveryCoordinator = null;
            }
            return super.restore_state(os, ot);
        }
        catch (IOException ex) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_coordinator_generror("ServerTransaction.restore_state", ex);
            return false;
        }
    }

    @Override
    public String toString() {
        return "ServerTransaction < " + this.get_uid() + " >";
    }

    protected ServerTransaction(Uid recoveringActUid) {
        super(recoveringActUid);
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ServerTransaction::ServerTransaction ( " + recoveringActUid + " )"));
        }
        this._savingUid = recoveringActUid;
        this._sync = null;
        this._beforeCompleted = false;
        this._recoveryCoordinator = null;
        this._prepState = 6;
    }

    @Override
    protected final synchronized int preparedStatus() {
        return this._prepState;
    }

    private final int finalStatus() {
        int heuristic = super.getHeuristicDecision();
        switch (heuristic) {
            case 0: 
            case 7: {
                return super.status();
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 13;
            }
        }
        return 14;
    }
}

