/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.probe.Strings;

class EventInfo {
    private static final int EVENT_INFO_STRING_LIMIT = 80;
    private final boolean containerEvent;
    private final Type type;
    private final Set<Annotation> qualifiers;
    private final String eventString;
    private final InjectionPoint injectionPoint;
    private final List<ObserverMethod<?>> observers;
    private final long timestamp;

    EventInfo(Type type, Set<Annotation> qualifiers, Object event, InjectionPoint injectionPoint, List<ObserverMethod<?>> observers, boolean containerEvent, long timestamp) {
        this.type = type;
        this.qualifiers = qualifiers;
        this.injectionPoint = injectionPoint;
        this.containerEvent = containerEvent;
        this.eventString = Strings.abbreviate(event.toString(), 80);
        this.observers = observers;
        this.timestamp = timestamp;
    }

    boolean isContainerEvent() {
        return this.containerEvent;
    }

    Type getType() {
        return this.type;
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    String getEventString() {
        return this.eventString;
    }

    InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    List<ObserverMethod<?>> getObservers() {
        return this.observers;
    }

    long getTimestamp() {
        return this.timestamp;
    }
}

