/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.config.federation.parsers.SAMLConfigParser;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.picketlink.identity.federation.web.util.SecurityActions;

public class ConfigurationUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static PicketLinkType getConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        PicketLinkConfigParser parser = new PicketLinkConfigParser();
        PicketLinkType picketLinkType = (PicketLinkType)parser.parse(is);
        return picketLinkType;
    }

    public static IDPType getIDPConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        SAMLConfigParser parser = new SAMLConfigParser();
        return (IDPType)parser.parse(is);
    }

    public static SPType getSPConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        return (SPType)new SAMLConfigParser().parse(is);
    }

    public static Handlers getHandlers(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        return (Handlers)new SAMLConfigParser().parse(is);
    }

    public static PicketLinkType getConfiguration(ServletContext servletContext) throws ProcessingException, ConfigurationException {
        SAMLConfigurationProvider configurationProvider = ConfigurationUtil.getConfigurationProvider(servletContext);
        if (configurationProvider != null) {
            logger.debug("Loading PicketLink configuration configuration provider [" + configurationProvider + "].");
            return configurationProvider.getPicketLinkConfiguration();
        }
        logger.debug("Loading PicketLink configuration from [/WEB-INF/picketlink.xml].");
        InputStream is = ConfigurationUtil.getConfigurationInputStream(servletContext);
        if (is != null) {
            try {
                PicketLinkType picketLinkType = ConfigurationUtil.getConfiguration(is);
                return picketLinkType;
            }
            catch (ParsingException e) {
                throw logger.configurationError((Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static SAMLConfigurationProvider getConfigurationProvider(ServletContext servletContext) {
        String configProviderType = servletContext.getInitParameter("CONFIG_PROVIDER");
        if (configProviderType != null) {
            try {
                InputStream inputStream;
                SAMLConfigurationProvider configurationProvider = (SAMLConfigurationProvider)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), configProviderType).newInstance();
                if (AbstractSAMLConfigurationProvider.class.isInstance(configurationProvider) && (inputStream = ConfigurationUtil.getConfigurationInputStream(servletContext)) != null) {
                    ((AbstractSAMLConfigurationProvider)configurationProvider).setConsolidatedConfigFile(inputStream);
                }
                return configurationProvider;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config provider [" + configProviderType + "].", e);
            }
        }
        return null;
    }

    public static PicketLinkAuditHelper getAuditHelper(ServletContext servletContext) {
        String auditHelperType = servletContext.getInitParameter("AUDIT_HELPER");
        if (auditHelperType == null) {
            auditHelperType = PicketLinkAuditHelper.class.getName();
        }
        logger.debug("Creating audit helper [" + auditHelperType + "].");
        try {
            return (PicketLinkAuditHelper)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), auditHelperType).getConstructor(ServletContext.class).newInstance(servletContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create audit helper [" + auditHelperType + "].", e);
        }
    }

    public static InputStream getConfigurationInputStream(ServletContext servletContext) {
        return servletContext.getResourceAsStream("/WEB-INF/picketlink.xml");
    }
}

