/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.List;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueCreator;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.json.JSONArray;

public interface ServerSession
extends SecurityAuth {
    public String getName();

    public int getMinLargeMessageSize();

    public Object getConnectionID();

    public RemotingConnection getRemotingConnection();

    public boolean removeConsumer(long var1) throws Exception;

    public void acknowledge(long var1, long var3) throws Exception;

    public void individualAcknowledge(long var1, long var3) throws Exception;

    public void individualCancel(long var1, long var3, boolean var5) throws Exception;

    public void expire(long var1, long var3) throws Exception;

    public void rollback(boolean var1) throws Exception;

    public void commit() throws Exception;

    public void xaCommit(Xid var1, boolean var2) throws Exception;

    public void xaEnd(Xid var1) throws Exception;

    public void xaForget(Xid var1) throws Exception;

    public void xaJoin(Xid var1) throws Exception;

    public void xaPrepare(Xid var1) throws Exception;

    public void xaResume(Xid var1) throws Exception;

    public void xaRollback(Xid var1) throws Exception;

    public void xaStart(Xid var1) throws Exception;

    public void xaFailed(Xid var1) throws Exception;

    public void xaSuspend() throws Exception;

    public QueueCreator getQueueCreator();

    public List<Xid> xaGetInDoubtXids();

    public int xaGetTimeout();

    public void xaSetTimeout(int var1);

    public void start();

    public void stop();

    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public void deleteQueue(SimpleString var1) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, boolean var5) throws Exception;

    public QueueQueryResult executeQueueQuery(SimpleString var1) throws Exception;

    public BindingQueryResult executeBindingQuery(SimpleString var1) throws Exception;

    public void closeConsumer(long var1) throws Exception;

    public void receiveConsumerCredits(long var1, int var3) throws Exception;

    public void sendContinuations(int var1, long var2, byte[] var4, boolean var5) throws Exception;

    public void send(ServerMessage var1, boolean var2) throws Exception;

    public void sendLarge(MessageInternal var1) throws Exception;

    public void forceConsumerDelivery(long var1, long var3) throws Exception;

    public void requestProducerCredits(SimpleString var1, int var2) throws Exception;

    public void close(boolean var1) throws Exception;

    public void waitContextCompletion() throws Exception;

    public void setTransferring(boolean var1);

    public Set<ServerConsumer> getServerConsumers();

    public void addMetaData(String var1, String var2);

    public boolean addUniqueMetaData(String var1, String var2);

    public String getMetaData(String var1);

    public String[] getTargetAddresses();

    public void describeProducersInfo(JSONArray var1) throws Exception;

    public String getLastSentMessageID(String var1);

    public long getCreationTime();

    public OperationContext getSessionContext();

    public Transaction getCurrentTransaction();

    public void createSharedQueue(SimpleString var1, SimpleString var2, boolean var3, SimpleString var4) throws Exception;

    public List<MessageReference> getInTXMessagesForConsumer(long var1);
}

