/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.wildfly.extension.undertow.AccessLogAdd;
import org.wildfly.extension.undertow.AccessLogRemove;
import org.wildfly.extension.undertow.UndertowExtension;

public class AccessLogDefinition
extends PersistentResourceDefinition {
    protected static final SimpleAttributeDefinition PATTERN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern", ModelType.STRING, true).setDefaultValue(new ModelNode("common"))).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build();
    protected static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("default"))).build();
    protected static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, true).setDefaultValue(new ModelNode("access_log"))).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SUFFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING, true).setDefaultValue(new ModelNode(".log"))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition ROTATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DIRECTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("directory", ModelType.STRING).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode(new ValueExpression("${jboss.server.log.dir}")))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition USE_SERVER_LOG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-server-log", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition EXTENDED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extended", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition PREDICATE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("predicate", ModelType.STRING, true).setAllowExpression(true)).build();
    static final Collection<SimpleAttributeDefinition> ATTRIBUTES = Arrays.asList(WORKER, PATTERN, PREFIX, SUFFIX, ROTATE, DIRECTORY, USE_SERVER_LOG, RELATIVE_TO, EXTENDED, PREDICATE);
    static final AccessLogDefinition INSTANCE = new AccessLogDefinition();
    private final List<AccessConstraintDefinition> accessConstraints;

    private AccessLogDefinition() {
        super(UndertowExtension.PATH_ACCESS_LOG, (ResourceDescriptionResolver)UndertowExtension.getResolver("access-log"), (OperationStepHandler)AccessLogAdd.INSTANCE, (OperationStepHandler)AccessLogRemove.INSTANCE);
        SensitivityClassification sc = new SensitivityClassification("undertow", "web-access-log", false, false, false);
        this.accessConstraints = new SensitiveTargetAccessConstraintDefinition(sc).wrapAsList();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }
}

