/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedBindingRegistry;

public class ManagedDatagramSocketBinding
extends DatagramSocket
implements ManagedBinding {
    private final String name;
    private final ManagedBindingRegistry registry;

    ManagedDatagramSocketBinding(String name, ManagedBindingRegistry socketBindings, SocketAddress address) throws SocketException {
        super(address);
        this.name = name;
        this.registry = socketBindings;
        if (this.isBound()) {
            this.registry.registerBinding(this);
        }
    }

    @Override
    public String getSocketBindingName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return (InetSocketAddress)this.getLocalSocketAddress();
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
        super.bind(addr);
        if (this.registry != null) {
            this.registry.registerBinding(this);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.registry.unregisterBinding(this);
        }
    }
}

