/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.model.source.spi.ConstraintSource;
import org.hibernate.internal.util.compare.EqualsHelper;

class AbstractConstraintSource
implements ConstraintSource {
    protected final String name;
    protected final String tableName;
    protected final ArrayList<String> columnNames = new ArrayList();

    protected AbstractConstraintSource(String name, String tableName) {
        assert (name != null) : "Constraint name was null";
        this.name = name;
        this.tableName = tableName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<String> columnNames() {
        return this.columnNames;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstraintSource that = (AbstractConstraintSource)o;
        return EqualsHelper.equals(this.name, that.name) && EqualsHelper.equals(this.tableName, that.tableName) && this.columnNames.equals(that.columnNames);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        result = 31 * result + this.columnNames.hashCode();
        return result;
    }
}

