/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.impl;

import java.util.Properties;
import java.util.concurrent.Executor;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.impl.ClassLoaderContextHandle;
import org.wildfly.extension.batch.jberet.impl.ContextHandle;
import org.wildfly.extension.batch.jberet.impl.NamespaceContextHandle;
import org.wildfly.extension.batch.jberet.impl.SecurityContextHandle;
import org.wildfly.extension.batch.jberet.impl.WildFlyArtifactFactory;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.jberet.BatchEnvironmentFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentService
implements Service<BatchEnvironment> {
    private static final Properties PROPS = new Properties();
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<JobExecutor> jobExecutorInjector = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerInjector = new InjectedValue();
    private final InjectedValue<RequestController> requestControllerInjector = new InjectedValue();
    private final InjectedValue<JobRepository> jobRepositoryInjector = new InjectedValue();
    private final ClassLoader classLoader;
    private final JobXmlResolver jobXmlResolver;
    private final String deploymentName;
    private BatchEnvironment batchEnvironment = null;
    private ControlPoint controlPoint;

    public BatchEnvironmentService(ClassLoader classLoader, JobXmlResolver jobXmlResolver, String deploymentName) {
        this.classLoader = classLoader;
        this.jobXmlResolver = jobXmlResolver;
        this.deploymentName = deploymentName;
    }

    public synchronized void start(StartContext context) throws StartException {
        BatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        RequestController requestController = (RequestController)this.requestControllerInjector.getOptionalValue();
        this.controlPoint = requestController != null ? requestController.getControlPoint(this.deploymentName, "batch-executor-service") : null;
        WildFlyBatchEnvironment batchEnvironment = new WildFlyBatchEnvironment((BeanManager)this.beanManagerInjector.getOptionalValue(), (JobExecutor)this.jobExecutorInjector.getValue(), (TransactionManager)this.transactionManagerInjector.getValue(), (JobRepository)this.jobRepositoryInjector.getValue(), this.jobXmlResolver, this.controlPoint);
        BatchEnvironmentFactory.getInstance().add(this.classLoader, (BatchEnvironment)batchEnvironment);
        this.batchEnvironment = batchEnvironment;
    }

    public synchronized void stop(StopContext context) {
        BatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        BatchEnvironmentFactory.getInstance().remove(this.classLoader);
        this.batchEnvironment = null;
        if (this.controlPoint != null) {
            ((RequestController)this.requestControllerInjector.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public synchronized BatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public InjectedValue<JobExecutor> getJobExecutorInjector() {
        return this.jobExecutorInjector;
    }

    public InjectedValue<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjector;
    }

    public InjectedValue<RequestController> getRequestControllerInjector() {
        return this.requestControllerInjector;
    }

    public InjectedValue<JobRepository> getJobRepositoryInjector() {
        return this.jobRepositoryInjector;
    }

    private class WildFlyBatchEnvironment
    implements BatchEnvironment {
        private final ArtifactFactory artifactFactory;
        private final JobExecutor jobExecutor;
        private final TransactionManager transactionManager;
        private final JobRepository jobRepository;
        private final JobXmlResolver jobXmlResolver;
        private final ControlPoint controlPoint;

        WildFlyBatchEnvironment(BeanManager beanManager, JobExecutor jobExecutor, TransactionManager transactionManager, JobRepository jobRepository, JobXmlResolver jobXmlResolver, ControlPoint controlPoint) {
            this.jobXmlResolver = jobXmlResolver;
            this.artifactFactory = new WildFlyArtifactFactory(beanManager);
            this.jobExecutor = jobExecutor;
            this.transactionManager = transactionManager;
            this.controlPoint = controlPoint;
            this.jobRepository = jobRepository;
        }

        public ClassLoader getClassLoader() {
            return BatchEnvironmentService.this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public void submitTask(final JobTask jobTask) {
            final ContextHandle contextHandle = this.createContextHandle();
            JobTask task = new JobTask(){

                public int getRequiredRemainingPermits() {
                    return jobTask.getRequiredRemainingPermits();
                }

                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        jobTask.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            };
            if (this.controlPoint == null) {
                this.jobExecutor.execute(task);
            } else {
                this.controlPoint.queueTask((Runnable)task, (Executor)this.jobExecutor, -1L, null, false);
            }
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public JobXmlResolver getJobXmlResolver() {
            return this.jobXmlResolver;
        }

        public Properties getBatchConfigurationProperties() {
            return PROPS;
        }

        private ContextHandle createContextHandle() {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(BatchEnvironmentService.this.classLoader) : new ClassLoaderContextHandle(tccl);
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(), new SecurityContextHandle());
        }
    }
}

