/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ConnectorService;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public final class ConnectorsService
implements ActiveMQComponent {
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledPool;
    private boolean isStarted = false;
    private final Configuration configuration;
    private final Set<ConnectorService> connectors = new HashSet<ConnectorService>();
    private final ServiceRegistry serviceRegistry;

    public ConnectorsService(Configuration configuration, StorageManager storageManager, ScheduledExecutorService scheduledPool, PostOffice postOffice, ServiceRegistry serviceRegistry) {
        this.configuration = configuration;
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.postOffice = postOffice;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void start() throws Exception {
        Collection<Pair<ConnectorServiceFactory, ConnectorServiceConfiguration>> connectorServiceFactories = this.serviceRegistry.getConnectorServices(this.configuration.getConnectorServiceConfigurations());
        for (Pair<ConnectorServiceFactory, ConnectorServiceConfiguration> pair : connectorServiceFactories) {
            this.createService(pair.getB(), pair.getA());
        }
        for (ConnectorService connector : this.connectors) {
            try {
                connector.start();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorStartingConnectorService(e, connector.getName());
            }
        }
        this.isStarted = true;
    }

    public void createService(ConnectorServiceConfiguration info, ConnectorServiceFactory factory) {
        Set<String> invalid;
        if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
            ActiveMQServerLogger.LOGGER.connectorKeysInvalid(ConfigurationHelper.stringSetToCommaListString(invalid));
            return;
        }
        invalid = ConfigurationHelper.checkKeysExist(factory.getRequiredProperties(), info.getParams().keySet());
        if (!invalid.isEmpty()) {
            ActiveMQServerLogger.LOGGER.connectorKeysMissing(ConfigurationHelper.stringSetToCommaListString(invalid));
            return;
        }
        ConnectorService connectorService = factory.createConnectorService(info.getConnectorName(), info.getParams(), this.storageManager, this.postOffice, this.scheduledPool);
        this.connectors.add(connectorService);
    }

    @Override
    public void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        for (ConnectorService connector : this.connectors) {
            try {
                connector.stop();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorStoppingConnectorService(e, connector.getName());
            }
        }
        this.connectors.clear();
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public Set<ConnectorService> getConnectors() {
        return this.connectors;
    }
}

