/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.service;

import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;

public class FileIdentityStoreService
implements Service<FileIdentityStoreService> {
    private final String relativeTo;
    private final String workingDir;
    private final FileStoreConfigurationBuilder fileStoreConfigurationBuilder;
    private InjectedValue<PathManager> pathManager = new InjectedValue();

    public FileIdentityStoreService(FileStoreConfigurationBuilder fileStoreConfigurationBuilder, String workingDir, String relativeTo) {
        this.fileStoreConfigurationBuilder = fileStoreConfigurationBuilder;
        this.workingDir = workingDir;
        this.relativeTo = relativeTo;
    }

    public void start(StartContext startContext) throws StartException {
        String resolvedPath = ((PathManager)this.getPathManager().getValue()).resolveRelativePathEntry(this.workingDir, this.relativeTo);
        this.fileStoreConfigurationBuilder.workingDirectory(resolvedPath);
    }

    public void stop(StopContext stopContext) {
    }

    public FileIdentityStoreService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }
}

