/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class ServletHandler
implements HttpHandler {
    private final ManagedServlet managedServlet;
    private static final AtomicLongFieldUpdater<ServletHandler> unavailableUntilUpdater = AtomicLongFieldUpdater.newUpdater(ServletHandler.class, "unavailableUntil");
    private volatile long unavailableUntil = 0L;

    public ServletHandler(ManagedServlet managedServlet) {
        this.managedServlet = managedServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws IOException, ServletException {
        if (this.managedServlet.isPermanentlyUnavailable()) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 404 for servlet %s due to permanent unavailability", this.managedServlet.getServletInfo().getName());
            exchange.setStatusCode(404);
            return;
        }
        long until = this.unavailableUntil;
        if (until != 0L) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 503 for servlet %s due to temporary unavailability", this.managedServlet.getServletInfo().getName());
            if (System.currentTimeMillis() < until) {
                exchange.setStatusCode(503);
                return;
            }
            unavailableUntilUpdater.compareAndSet(this, until, 0L);
        }
        if (!this.managedServlet.getServletInfo().isAsyncSupported()) {
            exchange.putAttachment(AsyncContextImpl.ASYNC_SUPPORTED, (Object)false);
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest request = servletRequestContext.getServletRequest();
        ServletResponse response = servletRequestContext.getServletResponse();
        InstanceHandle<? extends Servlet> servlet = null;
        try {
            servlet = this.managedServlet.getServlet();
            servlet.getInstance().service(request, response);
        }
        catch (UnavailableException e) {
            if (e.isPermanent()) {
                UndertowServletLogger.REQUEST_LOGGER.stoppingServletDueToPermanentUnavailability(this.managedServlet.getServletInfo().getName(), e);
                this.managedServlet.stop();
                this.managedServlet.setPermanentlyUnavailable(true);
                exchange.setStatusCode(404);
            } else {
                unavailableUntilUpdater.set(this, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
                UndertowServletLogger.REQUEST_LOGGER.stoppingServletUntilDueToTemporaryUnavailability(this.managedServlet.getServletInfo().getName(), new Date(until), e);
                exchange.setStatusCode(503);
            }
        }
        finally {
            if (servlet != null) {
                servlet.release();
            }
        }
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }
}

