/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.embedded.EmbedHostControllerHandler;
import org.jboss.as.cli.embedded.EmbedServerHandler;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.embedded.StopEmbeddedHostControllerHandler;
import org.jboss.as.cli.embedded.StopEmbeddedServerHandler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EmbeddedControllerHandlerRegistrar {
    private static final boolean hasModules;
    private static final boolean modular;

    public static final AtomicReference<EmbeddedProcessLaunch> registerEmbeddedCommands(CommandRegistry commandRegistry, CommandContext ctx) throws CommandLineException {
        AtomicReference<EmbeddedProcessLaunch> serverReference = new AtomicReference<EmbeddedProcessLaunch>();
        if (hasModules) {
            commandRegistry.registerHandler((CommandHandler)EmbedServerHandler.create(serverReference, ctx, modular), "embed-server");
            commandRegistry.registerHandler((CommandHandler)new StopEmbeddedServerHandler(serverReference), "stop-embedded-server");
            commandRegistry.registerHandler((CommandHandler)EmbedHostControllerHandler.create(serverReference, ctx, modular), "embed-host-controller");
            commandRegistry.registerHandler((CommandHandler)new StopEmbeddedHostControllerHandler(serverReference), "stop-embedded-host-controller");
        }
        return serverReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<?> clazz = null;
        Object obj = null;
        String systemPkgs = WildFlySecurityManager.getPropertyPrivileged("jboss.modules.system.pkgs", null);
        try {
            WildFlySecurityManager.setPropertyPrivileged("jboss.modules.system.pkgs", "org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client,org.jboss.logging,org.jboss.logmanager");
            String classname = "org.jboss.modules.Module";
            ClassLoader cl = EmbeddedControllerHandlerRegistrar.class.getClassLoader();
            clazz = cl.loadClass(classname);
            Class[] parameterTypes = new Class[]{ClassLoader.class, Boolean.TYPE};
            Method method = clazz.getDeclaredMethod("forClassLoader", parameterTypes);
            Object[] args = new Object[]{cl, Boolean.TRUE};
            obj = method.invoke(null, args);
        }
        catch (Exception exception) {
        }
        finally {
            if (systemPkgs == null) {
                WildFlySecurityManager.clearPropertyPrivileged("jboss.modules.system.pkgs");
            } else {
                WildFlySecurityManager.setPropertyPrivileged("jboss.modules.system.pkgs", systemPkgs);
            }
        }
        hasModules = clazz != null;
        modular = obj != null;
    }
}

