/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.Map;
import javax.servlet.ServletContext;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IdentityURLProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.bindings.wildfly.sp.IdentityURLProviderHandler;
import org.picketlink.identity.federation.bindings.wildfly.sp.SPFormAuthenticationMechanism;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class SPServletExtension
implements ServletExtension {
    private static final PicketLinkLogger LOGGER = PicketLinkLoggerFactory.getLogger();
    private final SAMLConfigurationProvider configurationProvider;
    private final PicketLinkAuditHelper auditHelper;

    public SPServletExtension(SAMLConfigurationProvider configurationProvider, PicketLinkAuditHelper auditHelper) {
        this.configurationProvider = configurationProvider;
        this.auditHelper = auditHelper;
    }

    public SPServletExtension() {
        this(null, null);
    }

    public void handleDeployment(final DeploymentInfo deploymentInfo, final ServletContext servletContext) {
        LOGGER.debug("Processing PicketLink Extension [" + this.getClass() + "].");
        try {
            final SAMLConfigurationProvider configurationProvider = this.getConfigurationProvider(servletContext);
            final PicketLinkType configuration = configurationProvider != null ? configurationProvider.getPicketLinkConfiguration() : ConfigurationUtil.getConfiguration((ServletContext)servletContext);
            if (configuration == null) {
                LOGGER.debug("No configuration found for deployment [" + deploymentInfo.getDeploymentName() + "].");
                return;
            }
            ProviderType providerType = configuration.getIdpOrSP();
            if (SPType.class.isInstance(providerType)) {
                LOGGER.debug("Configuring deployment [" + deploymentInfo.getDeploymentName() + "] as a SAML Service Provider.");
                deploymentInfo.addAuthenticationMechanism("FORM", new AuthenticationMechanismFactory(){

                    public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
                        try {
                            String loginPage = properties.get("login_page");
                            String errorPage = properties.get("error_page");
                            PicketLinkAuditHelper auditHelper = SPServletExtension.this.getAuditHelper(configuration, servletContext);
                            if (configurationProvider != null) {
                                return new SPFormAuthenticationMechanism(formParserFactory, mechanismName, loginPage, errorPage, servletContext, configurationProvider, auditHelper);
                            }
                            return new SPFormAuthenticationMechanism(formParserFactory, mechanismName, loginPage, errorPage, servletContext, configuration, auditHelper);
                        }
                        catch (ProcessingException e) {
                            throw new RuntimeException("Could not create SAML Authentication Mechanism for deployment [" + deploymentInfo.getDeploymentName() + "].", e);
                        }
                    }
                });
                SPType spType = (SPType)providerType;
                IdentityURLProviderType identityURLProvider = spType.getIdentityURLProvider();
                if (identityURLProvider != null) {
                    deploymentInfo.addOuterHandlerChainWrapper(IdentityURLProviderHandler.wrapper(spType, servletContext));
                }
            }
        }
        catch (ProcessingException e) {
            throw new RuntimeException("Error configuring PicketLink SAML extension [" + this.getClass() + "] to deployment [" + deploymentInfo.getDeploymentName() + "].", e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Could not load PicketLink configuration for deployment [" + deploymentInfo.getDeploymentName() + "].", e);
        }
    }

    private SAMLConfigurationProvider getConfigurationProvider(ServletContext servletContext) {
        if (this.configurationProvider == null) {
            return ConfigurationUtil.getConfigurationProvider((ServletContext)servletContext);
        }
        return this.configurationProvider;
    }

    private PicketLinkAuditHelper getAuditHelper(PicketLinkType configuration, ServletContext servletContext) {
        if (configuration.isEnableAudit() && this.auditHelper == null) {
            return ConfigurationUtil.getAuditHelper((ServletContext)servletContext);
        }
        return this.auditHelper;
    }
}

