/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import com.arjuna.common.logging.commonLogger;
import com.arjuna.common.util.ConfigurationInfo;
import com.arjuna.common.util.propertyservice.FileLocator;
import com.arjuna.common.util.propertyservice.PropertiesFactoryStax;
import com.arjuna.common.util.propertyservice.StringPropertyReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public abstract class AbstractPropertiesFactory {
    private volatile Properties defaultProperties = null;

    public Properties getDefaultProperties() {
        if (this.defaultProperties == null) {
            this.initDefaultProperties("com.arjuna.ats.arjuna.common.propertiesFile");
        }
        return this.defaultProperties;
    }

    public Properties getPropertiesFromFile(String propertyFileName, ClassLoader classLoader) {
        String propertiesSourceUri = null;
        try {
            propertiesSourceUri = FileLocator.locateFile(propertyFileName, classLoader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            URL url = AbstractPropertiesFactory.class.getResource("/default-" + propertyFileName);
            if (url == null) {
                commonLogger.i18NLogger.warn_could_not_find_config_file(url);
            } else {
                propertiesSourceUri = url.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("invalid property file " + propertiesSourceUri, e);
        }
        Properties properties = null;
        try {
            if (propertiesSourceUri != null) {
                properties = this.loadFromFile(propertiesSourceUri);
            }
            properties = this.applySystemProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to load properties from " + propertiesSourceUri, e);
        }
        return properties;
    }

    private Properties applySystemProperties(Properties inputProperties) {
        Properties outputProperties = new Properties(inputProperties);
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            outputProperties.setProperty(key, System.getProperty(key));
        }
        return outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromFile(String uri) throws IOException {
        InputStream inputStream = null;
        Properties inputProperties = new Properties();
        Properties outputProperties = new Properties();
        inputStream = new File(uri).exists() ? new FileInputStream(uri) : new URL(uri).openStream();
        try {
            this.loadFromXML(inputProperties, inputStream);
        }
        finally {
            inputStream.close();
        }
        Enumeration<?> namesEnumeration = inputProperties.propertyNames();
        while (namesEnumeration.hasMoreElements()) {
            String propertyName = (String)namesEnumeration.nextElement();
            String propertyValue = inputProperties.getProperty(propertyName);
            propertyValue = propertyValue.trim();
            propertyValue = StringPropertyReplacer.replaceProperties(propertyValue);
            outputProperties.setProperty(propertyName, propertyValue);
        }
        return outputProperties;
    }

    private synchronized void initDefaultProperties(String fileNamePropertyKey) {
        if (this.defaultProperties != null) {
            return;
        }
        String propertyFileName = System.getProperty(fileNamePropertyKey);
        if (propertyFileName == null) {
            propertyFileName = ConfigurationInfo.getPropertiesFile();
        }
        if (propertyFileName == null) {
            throw new RuntimeException("Unable to resolve property file name");
        }
        this.defaultProperties = this.getPropertiesFromFile(propertyFileName, PropertiesFactoryStax.class.getClassLoader());
    }

    protected abstract Properties loadFromXML(Properties var1, InputStream var2) throws IOException;
}

