/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.UUID;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.RemoveListener;

public class DistributableCache<K, V extends Identifiable<K> & Contextual<Batch>>
implements Cache<K, V> {
    private final BeanManager<UUID, K, V, Batch> manager;
    private final StatefulObjectFactory<V> factory;
    private final RemoveListener<V> listener;

    public DistributableCache(BeanManager<UUID, K, V, Batch> manager, StatefulObjectFactory<V> factory) {
        this.manager = manager;
        this.factory = factory;
        this.listener = new RemoveListenerAdapter(factory);
    }

    public Affinity getStrictAffinity() {
        return this.manager.getStrictAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Affinity affinity = this.manager.getWeakAffinity(id);
            return affinity;
        }
    }

    public K createIdentifier() {
        return (K)this.manager.getBeanIdentifierFactory().createIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V create() {
        boolean newGroup = false;
        boolean success = false;
        UUID group = (UUID)CURRENT_GROUP.get();
        Batch batch = this.manager.getBatcher().createBatch();
        try {
            Identifiable identifiable;
            block10: {
                if (group == null) {
                    newGroup = true;
                    group = (UUID)this.manager.getGroupIdentifierFactory().createIdentifier();
                    CURRENT_GROUP.set(group);
                }
                try {
                    Identifiable instance = (Identifiable)this.factory.createInstance();
                    Object id = instance.getId();
                    this.manager.createBean(id, (Object)group, (Object)instance).close();
                    success = true;
                    identifiable = instance;
                    if (!newGroup) break block10;
                    CURRENT_GROUP.remove();
                }
                catch (Throwable throwable) {
                    if (newGroup) {
                        CURRENT_GROUP.remove();
                    }
                    throw throwable;
                }
            }
            return (V)identifiable;
        }
        finally {
            if (success) {
                batch.close();
            } else {
                batch.discard();
            }
        }
    }

    @Override
    public V get(K id) {
        Batch batch = this.manager.getBatcher().createBatch();
        try {
            Bean bean = this.manager.findBean(id);
            if (bean == null) {
                batch.close();
                return null;
            }
            Identifiable result = (Identifiable)bean.acquire();
            ((Contextual)((Object)result)).setCacheContext(batch);
            return (V)result;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
    }

    @Override
    public void release(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            Bean bean = this.manager.findBean(value.getId());
            if (bean != null && bean.release()) {
                bean.close();
            }
        }
    }

    @Override
    public void remove(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            Bean bean = this.manager.findBean(id);
            if (bean != null) {
                bean.remove(this.listener);
            }
        }
    }

    @Override
    public void discard(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            Bean bean = this.manager.findBean(value.getId());
            if (bean != null) {
                bean.remove(null);
            }
        }
    }

    @Override
    public boolean contains(K id) {
        return this.manager.containsBean(id);
    }

    @Override
    public void start() {
        this.manager.start();
    }

    @Override
    public void stop() {
        this.manager.stop();
    }

    @Override
    public int getCacheSize() {
        return this.manager.getActiveCount();
    }

    @Override
    public int getPassivatedCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public int getTotalSize() {
        return this.manager.getActiveCount() + this.manager.getPassiveCount();
    }
}

