/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.LdapReferralException;
import javax.naming.ldap.Rdn;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcher;
import org.jboss.as.domain.management.security.SecurityActions;

public class LdapGroupSearcherFactory {
    private static final int searchTimeLimit = 10000;
    private static final String PARSE_ROLES_FROM_DN = "org.jboss.as.domain.management.security.parseGroupNameFromLdapDN";

    static LdapSearcher<LdapEntry[], LdapEntry> createForGroupToPrincipal(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy, boolean preferOriginalConnection) {
        return new GroupToPrincipalSearcher(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy, preferOriginalConnection);
    }

    static LdapSearcher<LdapEntry[], LdapEntry> createForPrincipalToGroup(String groupAttribute, String groupNameAttribute, boolean preferOriginalConnection, boolean skipMissingGroups) {
        return new PrincipalToGroupSearcher(groupAttribute, groupNameAttribute, preferOriginalConnection, skipMissingGroups);
    }

    private static SearchControls createSearchControl(boolean recursive, String[] attributes) {
        if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("createSearchControl recursive=%b,  attributes=%s", recursive, Arrays.toString(attributes));
        }
        SearchControls searchControls = new SearchControls();
        if (recursive) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setReturningAttributes(attributes);
        searchControls.setTimeLimit(10000);
        return searchControls;
    }

    private static String[] createArray(String ... elements) {
        ArrayList<String> elementList = new ArrayList<String>(elements.length);
        for (String current : elements) {
            if (current == null) continue;
            elementList.add(current);
        }
        return elementList.toArray(new String[elementList.size()]);
    }

    private static class PrincipalToGroupSearcher
    implements LdapSearcher<LdapEntry[], LdapEntry> {
        private final String groupAttribute;
        private final String groupNameAttribute;
        private final boolean preferOriginalConnection;
        private final boolean skipMissingGroups;

        private PrincipalToGroupSearcher(String groupAttribute, String groupNameAttribute, boolean preferOriginalConnection, boolean skipMissingGroups) {
            this.groupAttribute = groupAttribute;
            this.groupNameAttribute = groupNameAttribute;
            this.preferOriginalConnection = preferOriginalConnection;
            this.skipMissingGroups = skipMissingGroups;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher groupAttribute=%s", groupAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher groupNameAttribute=%s", groupNameAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher preferOriginalConnection=%b", preferOriginalConnection);
                DomainManagementLogger.SECURITY_LOGGER.tracef("PrincipalToGroupSearcher skipMissingGroups=%b", skipMissingGroups);
            }
        }

        @Override
        public LdapEntry[] search(LdapConnectionHandler originalConnectionHandler, LdapEntry entry) throws IOException, NamingException {
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            LdapConnectionHandler connectionHandler = originalConnectionHandler;
            URI originalReferralAddress = null;
            originalReferralAddress = entry.getReferralUri();
            if (originalReferralAddress != null && (connectionHandler = connectionHandler.findForReferral(originalReferralAddress)) == null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to obtain connection handler for referral URI %s", originalReferralAddress);
                return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
            }
            DirContext dirContext = connectionHandler.getConnection();
            Attributes groups = dirContext.getAttributes(entry.getDistinguishedName(), new String[]{this.groupAttribute});
            Attribute groupRef = groups.get(this.groupAttribute);
            if (this.preferOriginalConnection) {
                connectionHandler = originalConnectionHandler;
                originalReferralAddress = null;
            }
            boolean shouldParseGroupFromDN = Boolean.valueOf(SecurityActions.getSystemProperty(LdapGroupSearcherFactory.PARSE_ROLES_FROM_DN, null));
            if (groupRef != null && groupRef.size() > 0) {
                NamingEnumeration<?> groupRefValues = groupRef.getAll();
                while (groupRefValues.hasMore()) {
                    String distingushedName = ((String)groupRefValues.next()).replace("\\", "\\\\").replace("/", "\\/");
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Group found with distinguishedName=%s", distingushedName);
                    LdapConnectionHandler groupLoadHandler = connectionHandler;
                    URI groupReferralAddress = originalReferralAddress;
                    if (shouldParseGroupFromDN) {
                        LdapEntry parsedGroup = this.parseRole(distingushedName, this.groupNameAttribute, groupReferralAddress);
                        if (parsedGroup != null) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Parsed group %s for group with distringuishedName=%s", parsedGroup.getSimpleName(), parsedGroup.getDistinguishedName());
                            foundEntries.add(parsedGroup);
                            continue;
                        }
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Failed to parse %s from distinguishedName=%s", this.groupNameAttribute, distingushedName);
                        continue;
                    }
                    boolean retry = false;
                    String simpleName = null;
                    do {
                        retry = false;
                        try {
                            String[] stringArray;
                            dirContext = groupLoadHandler.getConnection();
                            if (this.groupNameAttribute != null) {
                                String[] stringArray2 = new String[1];
                                stringArray = stringArray2;
                                stringArray2[0] = this.groupNameAttribute;
                            } else {
                                stringArray = new String[]{};
                            }
                            Attributes groupNameAttrs = dirContext.getAttributes(distingushedName, stringArray);
                            if (this.groupNameAttribute != null) {
                                Attribute groupNameAttr = groupNameAttrs.get(this.groupNameAttribute);
                                simpleName = (String)groupNameAttr.get();
                                DomainManagementLogger.SECURITY_LOGGER.tracef("simpleName %s loaded for group with distinguishedName=%s", simpleName, distingushedName);
                            } else {
                                DomainManagementLogger.SECURITY_LOGGER.trace("No groupNameAttribute to load simpleName");
                            }
                            foundEntries.add(new LdapEntry(simpleName, distingushedName, groupReferralAddress));
                        }
                        catch (NameNotFoundException e) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Failed to query roleNameAttrName: %s", e.getMessage());
                            if (this.skipMissingGroups) continue;
                            throw e;
                        }
                        catch (LdapReferralException e) {
                            Object info = e.getReferralInfo();
                            try {
                                URI fullUri = new URI(info.toString());
                                groupReferralAddress = new URI(fullUri.getScheme(), null, fullUri.getHost(), fullUri.getPort(), null, null, null);
                                distingushedName = fullUri.getPath().substring(1);
                                DomainManagementLogger.SECURITY_LOGGER.tracef("Received referral with address '%s' for dn '%s'", groupReferralAddress.toString(), distingushedName);
                                groupLoadHandler = groupLoadHandler.findForReferral(groupReferralAddress);
                                if (groupLoadHandler == null) {
                                    DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to follow referral to '%s'", fullUri);
                                }
                                retry = true;
                            }
                            catch (URISyntaxException ue) {
                                DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to construct URI from referral: %s", info);
                            }
                        }
                    } while (retry);
                }
            } else {
                DomainManagementLogger.SECURITY_LOGGER.tracef("No groups found for %s", entry);
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }

        private LdapEntry parseRole(String dn, String groupNameAttribute, URI groupReferralAddress) {
            try {
                LdapName ldapName = new LdapName(dn);
                for (int i = ldapName.size() - 1; i >= 0; --i) {
                    Object value;
                    String rdnString = ldapName.get(i);
                    Rdn rdn = new Rdn(rdnString);
                    Attribute attr = rdn.toAttributes().get(groupNameAttribute);
                    if (attr == null || (value = attr.get()) == null) continue;
                    return new LdapEntry(value instanceof byte[] ? new String((byte[])value) : value.toString(), dn, groupReferralAddress);
                }
            }
            catch (NamingException e) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to parse role from DN (%s): %s", dn, e.getMessage());
            }
            return null;
        }
    }

    private static class GroupToPrincipalSearcher
    implements LdapSearcher<LdapEntry[], LdapEntry> {
        private final String baseDn;
        private final String groupDnAttribute;
        private final String groupNameAttribute;
        private final String[] attributeArray;
        private final String filterString;
        private final boolean recursive;
        private final BaseLdapGroupSearchResource.GroupName searchBy;
        private final boolean preferOriginalConnection;

        private GroupToPrincipalSearcher(String baseDn, String groupDnAttribute, String groupNameAttribute, String principalAttribute, boolean recursive, BaseLdapGroupSearchResource.GroupName searchBy, boolean preferOriginalConnection) {
            this.baseDn = baseDn;
            this.groupDnAttribute = groupDnAttribute;
            this.groupNameAttribute = groupNameAttribute;
            this.attributeArray = LdapGroupSearcherFactory.createArray(new String[]{groupDnAttribute, groupNameAttribute});
            this.filterString = String.format("(%s={0})", principalAttribute);
            this.recursive = recursive;
            this.searchBy = searchBy;
            this.preferOriginalConnection = preferOriginalConnection;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher baseDn=%s", baseDn);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher groupDnAttribute=%s", groupDnAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher groupNameAttribute=%s", groupNameAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher attributeArray=%s", Arrays.toString(this.attributeArray));
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher filterString=%s", this.filterString);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher recursive=%b", recursive);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher searchBy=%s", (Object)searchBy);
                DomainManagementLogger.SECURITY_LOGGER.tracef("GroupToPrincipalSearcher preferOriginalConnection=%b", preferOriginalConnection);
            }
        }

        @Override
        public LdapEntry[] search(LdapConnectionHandler originalConnectionHandler, LdapEntry entry) throws IOException, NamingException {
            SearchControls searchControls = LdapGroupSearcherFactory.createSearchControl(this.recursive, this.attributeArray);
            HashSet<LdapEntry> foundEntries = new HashSet<LdapEntry>();
            LdapConnectionHandler connectionHandler = originalConnectionHandler;
            URI referralAddress = null;
            referralAddress = entry.getReferralUri();
            if (referralAddress != null && !this.preferOriginalConnection) {
                if ((connectionHandler = connectionHandler.findForReferral(referralAddress)) == null) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to obtain connection handler for referral URI %s", referralAddress);
                    return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
                }
            } else {
                referralAddress = null;
            }
            Object[] searchParameter = this.getSearchParameter(entry);
            boolean trace = DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled();
            if (trace) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Performing search baseDn=%s, filterString=%s, searchParameter=%s", this.baseDn, this.filterString, Arrays.toString(searchParameter));
            }
            NamingEnumeration<SearchResult> searchResults = connectionHandler.getConnection().search(this.baseDn, this.filterString, searchParameter, searchControls);
            if (trace && !searchResults.hasMore()) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No search results found.");
            }
            while (searchResults.hasMore()) {
                SearchResult current = searchResults.next();
                Attributes attributes = current.getAttributes();
                if (attributes != null) {
                    LdapEntry newEntry = this.convertToLdapEntry(current, attributes, referralAddress);
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding %s", newEntry);
                    foundEntries.add(newEntry);
                    continue;
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("No attributes found for %s", current);
            }
            return foundEntries.toArray(new LdapEntry[foundEntries.size()]);
        }

        private LdapEntry convertToLdapEntry(SearchResult searchResult, Attributes attributes, URI referralAddress) throws NamingException {
            String simpleName = null;
            String distinguishedName = null;
            if (this.groupNameAttribute != null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Getting groupNameAttribute=%s", this.groupNameAttribute);
                Attribute groupNameAttr = attributes.get(this.groupNameAttribute);
                if (groupNameAttr != null) {
                    simpleName = (String)groupNameAttr.get();
                }
            }
            if (this.groupDnAttribute != null) {
                if ("dn".equals(this.groupDnAttribute)) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Obtaining dn using getNameInNamespace()");
                    distinguishedName = searchResult.getNameInNamespace();
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Getting groupDnAttribute=%s", this.groupDnAttribute);
                    Attribute groupDnAttr = attributes.get(this.groupDnAttribute);
                    if (groupDnAttr != null) {
                        distinguishedName = (String)groupDnAttr.get();
                    }
                }
            }
            return new LdapEntry(simpleName, distinguishedName, referralAddress);
        }

        private Object[] getSearchParameter(LdapEntry entry) {
            switch (this.searchBy) {
                case SIMPLE: {
                    return new String[]{entry.getSimpleName()};
                }
            }
            return new String[]{entry.getDistinguishedName()};
        }
    }
}

