/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class AbstractAddStepHandler
implements OperationStepHandler {
    static final Set<RuntimeCapability> NULL_CAPABILITIES = Collections.emptySet();
    private static final Set<? extends AttributeDefinition> NULL_ATTRIBUTES = Collections.emptySet();
    private final Set<RuntimeCapability> capabilities;
    protected final Collection<? extends AttributeDefinition> attributes;

    public AbstractAddStepHandler() {
        this.attributes = NULL_ATTRIBUTES;
        this.capabilities = NULL_CAPABILITIES;
    }

    public AbstractAddStepHandler(Collection<? extends AttributeDefinition> attributes) {
        this(NULL_CAPABILITIES, attributes);
    }

    public AbstractAddStepHandler(RuntimeCapability capability, Collection<? extends AttributeDefinition> attributes) {
        this(capability == null ? NULL_CAPABILITIES : Collections.singleton(capability), attributes);
    }

    public AbstractAddStepHandler(Set<RuntimeCapability> capabilities, Collection<? extends AttributeDefinition> attributes) {
        this.attributes = attributes == null ? NULL_ATTRIBUTES : attributes;
        this.capabilities = capabilities == null ? NULL_CAPABILITIES : capabilities;
    }

    public AbstractAddStepHandler(RuntimeCapability capability, AttributeDefinition ... attributes) {
        this(capability == null ? NULL_CAPABILITIES : Collections.singleton(capability), attributes);
    }

    public AbstractAddStepHandler(AttributeDefinition ... attributes) {
        this(NULL_CAPABILITIES, attributes);
    }

    public AbstractAddStepHandler(Set<RuntimeCapability> capabilities, AttributeDefinition ... attributes) {
        this(capabilities, attributes.length > 0 ? Arrays.asList(attributes) : NULL_ATTRIBUTES);
    }

    public AbstractAddStepHandler(Parameters parameters) {
        this.capabilities = parameters.capabilities == null ? NULL_CAPABILITIES : (parameters.capabilities.size() == 1 ? Collections.singleton(parameters.capabilities.iterator().next()) : Collections.unmodifiableSet(parameters.capabilities));
        this.attributes = parameters.attributes == null ? NULL_ATTRIBUTES : (parameters.attributes.size() == 1 ? Collections.singleton(parameters.attributes.iterator().next()) : Collections.unmodifiableSet(parameters.attributes));
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = this.createResource(context, operation);
        this.populateModel(context, operation, resource);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractAddStepHandler.this.performRuntime(context, operation, resource);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractAddStepHandler.this.rollbackRuntime(context, operation, resource);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected Resource createResource(OperationContext context, ModelNode operation) {
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            Set<String> orderedChildTypes = registration.getOrderedChildTypes();
            boolean orderedChildResource = registration.isOrderedChildResource();
            if (orderedChildResource || orderedChildTypes.size() > 0) {
                return new OrderedResourceCreator(orderedChildResource, orderedChildTypes).createResource(context, operation);
            }
        }
        return this.createResource(context);
    }

    protected Resource createResource(OperationContext context) {
        return context.createResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set<RuntimeCapability> capabilitySet = this.capabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.capabilities;
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : this.attributes) {
            if (!model.hasDefined(attributeDefinition.getName()) && !attributeDefinition.hasCapabilityRequirements()) continue;
            attributeDefinition.addCapabilityRequirements(context, resource, model.get(attributeDefinition.getName()));
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime();
    }

    @Deprecated
    protected boolean requiresRuntimeVerification() {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.performRuntime(context, operation, resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.performRuntime(context, operation, model, ServiceVerificationHandler.INSTANCE, new ArrayList());
        this.requiresRuntimeVerification();
    }

    @Deprecated
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        this.rollbackRuntime(context, operation, resource.getModel(), new ArrayList(0));
    }

    @Deprecated
    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
    }

    public static class Parameters {
        private Set<RuntimeCapability> capabilities = null;
        protected Set<AttributeDefinition> attributes = null;

        public Parameters addRuntimeCapability(RuntimeCapability ... capabilities) {
            Set<RuntimeCapability> capabilitySet = this.getOrCreateCapabilities();
            for (RuntimeCapability capability : capabilities) {
                capabilitySet.add(capability);
            }
            return this;
        }

        public Parameters addRuntimeCapability(Set<RuntimeCapability> capabilities) {
            this.getOrCreateCapabilities().addAll(capabilities);
            return this;
        }

        public Parameters addAttribute(AttributeDefinition ... attributeDefinitions) {
            Set<AttributeDefinition> attributeSet = this.getOrCreateAttributes();
            for (AttributeDefinition def : attributeDefinitions) {
                attributeSet.add(def);
            }
            return this;
        }

        public Parameters addAttribute(Collection<AttributeDefinition> attributeDefinitions) {
            this.getOrCreateAttributes().addAll(attributeDefinitions);
            return this;
        }

        private Set<RuntimeCapability> getOrCreateCapabilities() {
            if (this.capabilities == null) {
                this.capabilities = new HashSet<RuntimeCapability>();
            }
            return this.capabilities;
        }

        private Set<AttributeDefinition> getOrCreateAttributes() {
            if (this.attributes == null) {
                this.attributes = new HashSet<AttributeDefinition>();
            }
            return this.attributes;
        }
    }

    private class OrderedResourceCreator
    implements ResourceCreator {
        private final Set<String> orderedChildTypes;
        private final boolean indexedAdd;

        public OrderedResourceCreator(boolean indexedAdd, Set<String> orderedChildTypes) {
            this.indexedAdd = indexedAdd;
            this.orderedChildTypes = orderedChildTypes == null ? Collections.emptySet() : orderedChildTypes;
        }

        public OrderedResourceCreator(boolean indexedAdd, String ... orderedChildTypes) {
            this.indexedAdd = indexedAdd;
            HashSet<String> set = new HashSet<String>(orderedChildTypes.length);
            for (String type : orderedChildTypes) {
                set.add(type);
            }
            this.orderedChildTypes = set;
        }

        @Override
        public Resource createResource(OperationContext context, ModelNode operation) {
            Resource resource = Resource.Factory.create(false, this.orderedChildTypes);
            int index = -1;
            if (this.indexedAdd && operation.hasDefined("add-index")) {
                index = operation.get("add-index").asInt();
            }
            if (index >= 0) {
                context.addResource(PathAddress.EMPTY_ADDRESS, operation.get("add-index").asInt(), resource);
            } else {
                context.addResource(PathAddress.EMPTY_ADDRESS, resource);
            }
            return resource;
        }
    }

    private static interface ResourceCreator {
        public Resource createResource(OperationContext var1, ModelNode var2);
    }
}

