/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wsse;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.ReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSSecurityParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
                if (elementName.equalsIgnoreCase("UsernameToken")) {
                    startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    UsernameTokenType userNameToken = new UsernameTokenType();
                    QName idQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    Attribute idAttribute = startElement.getAttributeByName(idQName);
                    if (idAttribute == null) {
                        throw logger.parserRequiredAttribute("Id");
                    }
                    userNameToken.setId(StaxParserUtil.getAttributeValue((Attribute)idAttribute));
                    startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:userName");
                    }
                    String userName = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    AttributedString attributedString = new AttributedString();
                    attributedString.setValue(userName);
                    userNameToken.setUsername(attributedString);
                    EndElement onBehalfOfEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)onBehalfOfEndElement, (String)"UsernameToken");
                    return userNameToken;
                }
                if (!elementName.equals("SecurityTokenReference")) continue;
                return this.parseSecurityTokenReference(xmlEventReader);
            }
            StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        }
        throw logger.parserFailed("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nsURI);
    }

    private SecurityTokenReferenceType parseSecurityTokenReference(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"SecurityTokenReference");
        SecurityTokenReferenceType securityTokenRef = new SecurityTokenReferenceType();
        QName tokenType = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType");
        Attribute tokenTypeAttr = startElement.getAttributeByName(tokenType);
        if (tokenTypeAttr != null) {
            tokenType = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", tokenTypeAttr.getName().getPrefix());
            securityTokenRef.addOtherAttribute(tokenType, StaxParserUtil.getAttributeValue((Attribute)tokenTypeAttr));
        }
        XMLEvent xmlEvent = null;
        EndElement endElement = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            Attribute uriAttr;
            Attribute valueTypeAttr;
            xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                endElement = (EndElement)xmlEvent;
                tag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (tag.equals("SecurityTokenReference")) {
                    endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                if (tag.equals("Reference")) {
                    endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    continue;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("KeyIdentifier")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                KeyIdentifierType keyIdentifierType = new KeyIdentifierType();
                valueTypeAttr = startElement.getAttributeByName(new QName("ValueType"));
                if (valueTypeAttr != null) {
                    keyIdentifierType.setValueType(StaxParserUtil.getAttributeValue((Attribute)valueTypeAttr));
                }
                keyIdentifierType.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                securityTokenRef.addAny(keyIdentifierType);
                continue;
            }
            if (!tag.equals("Reference")) continue;
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            ReferenceType referenceType = new ReferenceType();
            valueTypeAttr = startElement.getAttributeByName(new QName("ValueType"));
            if (valueTypeAttr != null) {
                referenceType.setValueType(StaxParserUtil.getAttributeValue((Attribute)valueTypeAttr));
            }
            if ((uriAttr = startElement.getAttributeByName(new QName("URI"))) != null) {
                referenceType.setURI(StaxParserUtil.getAttributeValue((Attribute)uriAttr));
            }
            securityTokenRef.addAny(referenceType);
        }
        return securityTokenRef;
    }
}

