/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.protocol.remote.DiscoveredNodeRegistry;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.NodeInformation;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.common.net.Inet;
import org.wildfly.discovery.AllFilterSpec;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.EqualsFilterSpec;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemotingEJBDiscoveryProvider
implements DiscoveryProvider,
DiscoveredNodeRegistry {
    private final ConcurrentHashMap<String, NodeInformation> nodes = new ConcurrentHashMap();
    private final Set<URI> failedDestinations = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<String, Set<String>> clusterNodes = new ConcurrentHashMap();
    static final FilterSpec.Visitor<Void, EJBModuleIdentifier, RuntimeException> MI_EXTRACTOR = new FilterSpec.Visitor<Void, EJBModuleIdentifier, RuntimeException>(){

        @Override
        public EJBModuleIdentifier handle(EqualsFilterSpec filterSpec, Void parameter) throws RuntimeException {
            return RemotingEJBDiscoveryProvider.getIdentifierForAttribute(filterSpec.getAttribute(), filterSpec.getValue());
        }

        @Override
        public EJBModuleIdentifier handle(AllFilterSpec filterSpec, Void parameter) throws RuntimeException {
            for (FilterSpec child : filterSpec) {
                EJBModuleIdentifier match = child.accept(this);
                if (match == null) continue;
                return match;
            }
            return null;
        }
    };
    static final FilterSpec.Visitor<Void, String, RuntimeException> NODE_EXTRACTOR = new FilterSpec.Visitor<Void, String, RuntimeException>(){

        @Override
        public String handle(EqualsFilterSpec filterSpec, Void parameter) throws RuntimeException {
            AttributeValue value = filterSpec.getValue();
            return filterSpec.getAttribute().equals("node") && value.isString() ? value.toString() : null;
        }

        @Override
        public String handle(AllFilterSpec filterSpec, Void parameter) throws RuntimeException {
            for (FilterSpec child : filterSpec) {
                String match = child.accept(this);
                if (match == null) continue;
                return match;
            }
            return null;
        }
    };

    public RemotingEJBDiscoveryProvider() {
        Endpoint.getCurrent();
    }

    @Override
    public NodeInformation getNodeInformation(String nodeName) {
        return this.nodes.computeIfAbsent(nodeName, NodeInformation::new);
    }

    @Override
    public List<NodeInformation> getAllNodeInformation() {
        return new ArrayList<NodeInformation>(this.nodes.values());
    }

    @Override
    public void addNode(String clusterName, String nodeName) {
        this.clusterNodes.computeIfAbsent(clusterName, ignored -> Collections.newSetFromMap(new ConcurrentHashMap())).add(nodeName);
    }

    @Override
    public void removeNode(String clusterName, String nodeName) {
        this.clusterNodes.getOrDefault(clusterName, Collections.emptySet()).remove(nodeName);
    }

    @Override
    public void removeCluster(String clusterName) {
        Set<String> removed = this.clusterNodes.remove(clusterName);
        if (removed != null) {
            removed.clear();
        }
    }

    @Override
    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        if (!serviceType.implies(ServiceType.of("ejb", "jboss"))) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        RemoteEJBReceiver ejbReceiver = ejbClientContext.getAttachment(RemoteTransportProvider.ATTACHMENT_KEY);
        if (ejbReceiver == null) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        List<EJBClientConnection> configuredConnections = ejbClientContext.getConfiguredConnections();
        DiscoveryAttempt discoveryAttempt = new DiscoveryAttempt(serviceType, filterSpec, result, ejbReceiver, AuthenticationContext.captureCurrent());
        boolean ok = false;
        boolean discoveryConnections = false;
        for (EJBClientConnection eJBClientConnection : configuredConnections) {
            if (!eJBClientConnection.isForDiscovery()) continue;
            discoveryConnections = true;
            URI uri = eJBClientConnection.getDestination();
            if (this.failedDestinations.contains(uri)) {
                Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to configured connection %s, skipping because marked as failed", (Object)uri);
                continue;
            }
            ok = true;
            Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to configured connection %s", (Object)uri);
            discoveryAttempt.connectAndDiscover(uri);
        }
        block3: for (Map.Entry entry : this.clusterNodes.entrySet()) {
            String clusterName = (String)entry.getKey();
            Set nodeSet = (Set)entry.getValue();
            int maxConnections = ejbClientContext.getMaximumConnectedClusterNodes();
            block4: for (String nodeName : nodeSet) {
                NodeInformation.ClusterNodeInformation clusterInfo;
                if (maxConnections <= 0) continue block3;
                NodeInformation nodeInformation = this.nodes.get(nodeName);
                if (nodeInformation == null || (clusterInfo = (NodeInformation.ClusterNodeInformation)nodeInformation.getClustersByName().get(clusterName)) == null) continue;
                Map<String, CidrAddressTable<InetSocketAddress>> tables = clusterInfo.getAddressTablesByProtocol();
                for (Map.Entry<String, CidrAddressTable<InetSocketAddress>> entry2 : tables.entrySet()) {
                    String protocol = entry2.getKey();
                    CidrAddressTable<InetSocketAddress> addressTable = entry2.getValue();
                    for (CidrAddressTable.Mapping<InetSocketAddress> mapping : addressTable) {
                        InetSocketAddress destination = mapping.getValue();
                        InetSocketAddress source = ejbReceiver.getSourceAddress(destination);
                        if (!(source == null ? mapping.getRange().getNetmaskBits() == 0 : source.equals(destination))) continue;
                        try {
                            URI uri;
                            InetAddress destinationAddress = destination.getAddress();
                            String hostName = Inet.getHostNameIfResolved(destinationAddress);
                            if (hostName == null) {
                                hostName = destinationAddress instanceof Inet6Address ? '[' + Inet.toOptimalString(destinationAddress) + ']' : Inet.toOptimalString(destinationAddress);
                            }
                            if (this.failedDestinations.contains(uri = new URI(protocol, null, hostName, destination.getPort(), null, null, null))) continue;
                            --maxConnections;
                            Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to cluster %s connection %s", (Object)clusterName, (Object)uri);
                            discoveryAttempt.connectAndDiscover(uri);
                            ok = true;
                            continue block4;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                        }
                    }
                }
            }
        }
        if (discoveryConnections && !ok) {
            Logs.INVOCATION.tracef("EJB discovery provider: all connections marked failed, retrying ...", new Object[0]);
            for (EJBClientConnection eJBClientConnection : configuredConnections) {
                if (!eJBClientConnection.isForDiscovery()) continue;
                URI destination = eJBClientConnection.getDestination();
                Logs.INVOCATION.tracef("EJB discovery provider: attempting to connect to connection %s", (Object)destination);
                discoveryAttempt.connectAndDiscover(destination);
            }
        }
        discoveryAttempt.countDown();
        return discoveryAttempt;
    }

    static EJBModuleIdentifier getIdentifierForAttribute(String attribute, AttributeValue value) {
        if (!value.isString()) {
            return null;
        }
        String stringVal = value.toString();
        switch (attribute) {
            case "ejb-module": {
                String module;
                String app;
                String[] segments = stringVal.split("/");
                if (segments.length == 2) {
                    app = segments[0];
                    module = segments[1];
                } else if (segments.length == 1) {
                    app = "";
                    module = segments[0];
                } else {
                    return null;
                }
                return new EJBModuleIdentifier(app, module, "");
            }
            case "ejb-module-distinct": {
                String distinct;
                String module;
                String app;
                String[] segments = stringVal.split("/");
                if (segments.length == 3) {
                    app = segments[0];
                    module = segments[1];
                    distinct = segments[2];
                } else if (segments.length == 2) {
                    app = "";
                    module = segments[0];
                    distinct = segments[1];
                } else {
                    return null;
                }
                return new EJBModuleIdentifier(app, module, distinct);
            }
        }
        return null;
    }

    final class DiscoveryAttempt
    implements DiscoveryRequest,
    DiscoveryResult {
        private final ServiceType serviceType;
        private final FilterSpec filterSpec;
        private final DiscoveryResult discoveryResult;
        private final RemoteEJBReceiver ejbReceiver;
        private final AuthenticationContext authenticationContext;
        private final Endpoint endpoint;
        private final AtomicInteger outstandingCount = new AtomicInteger(1);
        private volatile boolean phase2;
        private final List<Runnable> cancellers = Collections.synchronizedList(new ArrayList());
        private final IoFuture.HandlingNotifier<ConnectionPeerIdentity, URI> outerNotifier;
        private final IoFuture.HandlingNotifier<EJBClientChannel, URI> innerNotifier;

        DiscoveryAttempt(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult, RemoteEJBReceiver ejbReceiver, AuthenticationContext authenticationContext) {
            this.serviceType = serviceType;
            this.filterSpec = filterSpec;
            this.discoveryResult = discoveryResult;
            this.ejbReceiver = ejbReceiver;
            this.authenticationContext = authenticationContext;
            this.endpoint = Endpoint.getCurrent();
            this.outerNotifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, URI>(){

                @Override
                public void handleCancelled(URI destination) {
                    DiscoveryAttempt.this.countDown();
                }

                @Override
                public void handleFailed(IOException exception, URI destination) {
                    DiscoveryAttempt.this.discoveryResult.reportProblem(exception);
                    RemotingEJBDiscoveryProvider.this.failedDestinations.add(destination);
                    DiscoveryAttempt.this.countDown();
                }

                @Override
                public void handleDone(ConnectionPeerIdentity data, URI destination) {
                    IoFuture<EJBClientChannel> future = ((DiscoveryAttempt)DiscoveryAttempt.this).ejbReceiver.serviceHandle.getClientService(data.getConnection(), OptionMap.EMPTY);
                    DiscoveryAttempt.this.onCancel(future::cancel);
                    future.addNotifier(DiscoveryAttempt.this.innerNotifier, destination);
                }
            };
            this.innerNotifier = new IoFuture.HandlingNotifier<EJBClientChannel, URI>(){

                @Override
                public void handleCancelled(URI destination) {
                    DiscoveryAttempt.this.countDown();
                }

                @Override
                public void handleFailed(IOException exception, URI destination) {
                    DiscoveryAttempt.this.discoveryResult.reportProblem(exception);
                    RemotingEJBDiscoveryProvider.this.failedDestinations.add(destination);
                    DiscoveryAttempt.this.countDown();
                }

                @Override
                public void handleDone(EJBClientChannel clientChannel, URI destination) {
                    RemotingEJBDiscoveryProvider.this.failedDestinations.remove(destination);
                    DiscoveryAttempt.this.countDown();
                }
            };
        }

        void connectAndDiscover(URI uri) {
            String scheme = uri.getScheme();
            if (scheme == null || !this.ejbReceiver.getRemoteTransportProvider().supportsProtocol(scheme) || !this.endpoint.isValidUriScheme(scheme)) {
                this.countDown();
                return;
            }
            this.outstandingCount.getAndIncrement();
            IoFuture future = AccessController.doPrivileged(() -> this.endpoint.getConnectedIdentity(uri, "ejb", "jboss", this.authenticationContext));
            this.onCancel(future::cancel);
            future.addNotifier(this.outerNotifier, uri);
        }

        void countDown() {
            if (this.outstandingCount.decrementAndGet() == 0) {
                DiscoveryResult result = this.discoveryResult;
                String node = this.filterSpec.accept(NODE_EXTRACTOR);
                EJBModuleIdentifier module = this.filterSpec.accept(MI_EXTRACTOR);
                if (this.phase2) {
                    if (node != null) {
                        NodeInformation information = (NodeInformation)RemotingEJBDiscoveryProvider.this.nodes.get(node);
                        if (information != null) {
                            information.discover(this.serviceType, this.filterSpec, result);
                        }
                    } else {
                        for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            information.discover(this.serviceType, this.filterSpec, result);
                        }
                    }
                    result.complete();
                } else {
                    boolean ok = false;
                    if (node != null) {
                        NodeInformation information = (NodeInformation)RemotingEJBDiscoveryProvider.this.nodes.get(node);
                        if (information != null && information.discover(this.serviceType, this.filterSpec, result)) {
                            ok = true;
                        }
                    } else {
                        for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            if (!information.discover(this.serviceType, this.filterSpec, result)) continue;
                            ok = true;
                        }
                    }
                    if (ok) {
                        result.complete();
                    } else {
                        HashSet<URI> everything = new HashSet<URI>();
                        for (EJBClientConnection connection : this.ejbReceiver.getReceiverContext().getClientContext().getConfiguredConnections()) {
                            if (!connection.isForDiscovery()) continue;
                            everything.add(connection.getDestination());
                        }
                        block5: for (NodeInformation information : RemotingEJBDiscoveryProvider.this.nodes.values()) {
                            for (NodeInformation.ClusterNodeInformation cni : information.getClustersByName().values()) {
                                Map<String, CidrAddressTable<InetSocketAddress>> atm = cni.getAddressTablesByProtocol();
                                for (Map.Entry<String, CidrAddressTable<InetSocketAddress>> entry2 : atm.entrySet()) {
                                    String protocol = entry2.getKey();
                                    CidrAddressTable<InetSocketAddress> addressTable = entry2.getValue();
                                    for (CidrAddressTable.Mapping<InetSocketAddress> mapping : addressTable) {
                                        InetSocketAddress destination = mapping.getValue();
                                        InetSocketAddress source = this.ejbReceiver.getSourceAddress(destination);
                                        if (!(source == null ? mapping.getRange().getNetmaskBits() == 0 : source.equals(destination))) continue;
                                        try {
                                            InetAddress destinationAddress = destination.getAddress();
                                            String hostName = Inet.getHostNameIfResolved(destinationAddress);
                                            if (hostName == null) {
                                                hostName = destinationAddress instanceof Inet6Address ? '[' + Inet.toOptimalString(destinationAddress) + ']' : Inet.toOptimalString(destinationAddress);
                                            }
                                            everything.add(new URI(protocol, null, hostName, destination.getPort(), null, null, null));
                                            continue block5;
                                        }
                                        catch (URISyntaxException uRISyntaxException) {
                                        }
                                    }
                                }
                            }
                        }
                        this.phase2 = true;
                        this.outstandingCount.incrementAndGet();
                        for (URI uri : everything) {
                            this.connectAndDiscover(uri);
                        }
                        this.countDown();
                    }
                }
            }
        }

        @Override
        public void complete() {
            this.countDown();
        }

        @Override
        public void reportProblem(Throwable description) {
            this.discoveryResult.reportProblem(description);
        }

        @Override
        public void addMatch(ServiceURL serviceURL) {
            this.discoveryResult.addMatch(serviceURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                for (Runnable canceller : cancellers) {
                    canceller.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onCancel(Runnable action) {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                cancellers.add(action);
            }
        }
    }
}

