/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client._private;

import java.io.IOException;
import java.net.URI;
import java.security.Permission;
import java.util.ServiceConfigurationError;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.remoting3.Endpoint;
import org.wildfly.transaction.client.DelayedEnlistmentException;
import org.wildfly.transaction.client.SynchronizationException;

@MessageLogger(projectCode="WFTXN", length=4)
public interface Log
extends BasicLogger {
    public static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)"org.wildfly.transaction.client");

    @Message(value="Subordinate XAResource at %s")
    public String subordinateXaResource(URI var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Failed to configure a remote transaction service provider")
    public void serviceConfigurationFailed(@Cause ServiceConfigurationError var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Closing the recovery stream after recovery failed threw an exception")
    public void recoverySuppressedException(@Cause XAException var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Got exception on inbound message")
    public void inboundException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Got exception on outbound message")
    public void outboundException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Failure on running doRecover during initialization")
    public void doRecoverFailureOnIntialization(@Cause Throwable var1);

    @Message(id=0, value="No transaction associated with the current thread")
    public IllegalStateException noTransaction();

    @Message(id=1, value="A transaction is already in progress")
    public NotSupportedException nestedNotSupported();

    @Message(id=2, value="Transaction is not a supported instance: %s")
    public InvalidTransactionException notSupportedTransaction(Transaction var1);

    @Message(id=3, value="Invalid transaction location URI (must be absolute): %s")
    public IllegalArgumentException invalidTransactionLocationUri(URI var1);

    @Message(id=4, value="No transaction provider installed for URI: %s")
    public IllegalArgumentException noProviderForUri(URI var1);

    @Message(id=5, value="Transaction not associated with this provider")
    public InvalidTransactionException transactionNotAssociatedWithThisProvider();

    @Message(id=6, value="Negative transaction timeout provided")
    public SystemException negativeTxnTimeout();

    @Message(id=7, value="A transaction is already associated with the current thread")
    public IllegalStateException alreadyAssociated();

    @Message(id=8, value="Cannot register a synchronization on a remote transaction")
    public UnsupportedOperationException registerSynchRemoteTransaction();

    @Message(id=9, value="Cannot enlist or delist resources on a remote transaction")
    public UnsupportedOperationException enlistDelistRemoteTransaction();

    @Message(id=10, value="Failed to receive protocol message from remote peer")
    public SystemException failedToReceive(@Cause IOException var1);

    @Message(id=11, value="Failed to send protocol message to remote peer")
    public SystemException failedToSend(@Cause Exception var1);

    @Message(id=12, value="The peer threw a SystemException; see peer logs for more information")
    public SystemException peerSystemException();

    @Message(id=13, value="The peer threw a SecurityException; see peer logs for more information")
    public SecurityException peerSecurityException();

    @Message(id=14, value="An unexpected protocol error occurred")
    public SystemException protocolError();

    @Message(id=15, value="The protocol operation was interrupted locally")
    public SystemException operationInterrupted();

    @Message(id=16, value="The remote peer rolled back the transaction")
    public RollbackException transactionRolledBackByPeer();

    @Message(id=17, value="Rollback-only transaction rolled back")
    public RollbackException rollbackOnlyRollback();

    @Message(id=18, value="Invalid transaction state")
    public IllegalStateException invalidTxnState();

    @Message(id=19, value="The peer threw a HeuristicMixedException; see peer logs for more information")
    public HeuristicMixedException peerHeuristicMixedException();

    @Message(id=20, value="The peer threw a HeuristicRollbackException; see peer logs for more information")
    public HeuristicRollbackException peerHeuristicRollbackException();

    @Message(id=21, value="Failed to acquire a connection for this operation")
    public SystemException failedToAcquireConnection(@Cause IOException var1);

    @Message(id=22, value="The resource manager for remote connection to %s was already enlisted in a transaction")
    public XAException duplicateEnlistment(@Field int var1, URI var2);

    @Message(id=23, value="Invalid flag value")
    public IllegalArgumentException invalidFlags();

    @Message(id=24, value="Duplicate transaction encountered for destination %s, transaction ID %s")
    public XAException duplicateTransaction(@Field int var1, URI var2, Xid var3);

    @Message(id=25, value="Failed to receive protocol message from remote peer")
    public XAException failedToReceiveXA(@Cause IOException var1, @Field int var2);

    @Message(id=26, value="Failed to send protocol message to remote peer")
    public XAException failedToSendXA(@Cause Exception var1, @Field int var2);

    @Message(id=27, value="The protocol operation was interrupted locally")
    public XAException operationInterruptedXA(@Field int var1);

    @Message(id=28, value="An unexpected protocol error occurred")
    public XAException protocolErrorXA(@Field int var1);

    @Message(id=29, value="The peer threw an XA exception")
    public XAException peerXaException(@Field int var1);

    @Message(id=30, value="Invalid handle type; expected %s, actually received %s")
    public IllegalArgumentException invalidHandleType(Class<?> var1, Class<?> var2);

    @Message(id=31, value="Commit not allowed on imported transaction")
    public SystemException commitOnImported();

    @Message(id=32, value="Rollback not allowed on imported transaction")
    public SystemException rollbackOnImported();

    @Message(id=33, value="Multiple remote transaction providers registered on endpoint: %s")
    public IllegalStateException multipleProvidersRegistered(Endpoint var1);

    @Message(id=34, value="Failed to acquire a connection for this operation")
    public XAException failedToAcquireConnectionXA(@Cause IOException var1, @Field int var2);

    @Message(id=35, value="Invalid handle type requested; expected a subtype of Transaction (non-inclusive), got %s")
    public IllegalArgumentException invalidHandleTypeRequested(Class<?> var1);

    @Message(id=36, value="Transaction operation failed due to thread interruption")
    public XAException interruptedXA(@Field int var1);

    @Message(id=37, value="No transaction provider associated with the current thread")
    public IllegalStateException noTransactionProvider();

    @Message(id=38, value="No local transaction provider associated with the current thread")
    public IllegalStateException noLocalTransactionProvider();

    @Message(id=39, value="Invalid null transaction")
    public NullPointerException nullTransaction();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=40, value="Rollback failed unexpectedly")
    public void rollbackFailed(@Cause Throwable var1);

    @Message(id=41, value="No provider interface matching %s is available from the transaction provider")
    public IllegalStateException noProviderInterface(Class<?> var1);

    @Message(id=42, value="Connection to remote transaction service failed")
    public SystemException connectionFailed(@Cause Throwable var1);

    @Message(id=43, value="Connection to remote transaction service interrupted")
    public SystemException connectionInterrupted();

    @Message(id=44, value="Unknown response received from peer")
    public SystemException unknownResponse();

    @Message(id=45, value="Failed to receive a response from peer")
    public SystemException responseFailed(@Cause IOException var1);

    @Message(id=46, value="The peer threw an IllegalStateException; see peer logs for more information")
    public IllegalStateException peerIllegalStateException();

    @Message(id=47, value="Unknown XA response received from peer")
    public XAException unknownResponseXa(@Field int var1);

    @Message(id=48, value="Failed to receive an XA response from peer")
    public XAException responseFailedXa(@Cause IOException var1, @Field int var2);

    @Message(id=49, value="Negative transaction timeout provided")
    public XAException negativeTxnTimeoutXa(@Field int var1);

    @Message(id=50, value="Unrecognized parameter with ID 0x%02x received")
    public XAException unrecognizedParameter(@Field int var1, int var2);

    @Message(id=51, value="Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead")
    public SystemException expectedParameter(int var1, int var2);

    @Message(id=52, value="Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead")
    public XAException expectedParameterXa(@Field int var1, int var2, int var3);

    @Message(id=53, value="Delayed enlistment has failed")
    public DelayedEnlistmentException delayedEnlistmentFailed(@Cause Throwable var1);

    @Message(id=54, value="Before-completion failed for resource %s")
    public SynchronizationException beforeCompletionFailed(@Cause Throwable var1, XAResource var2);

    @Message(id=55, value="Two-phase operation on single-phase transaction")
    public XAException onePhaseUserTransaction(@Field int var1);

    @Message(id=56, value="Unknown provider for remote transactions with URI scheme \"%s\"")
    public IllegalArgumentException unknownProvider(String var1);

    @Message(id=57, value="Attempted to outflow the same transaction from two different transaction managers")
    public SystemException outflowAcrossTransactionManagers();

    @Message(id=58, value="This delayed enlistment handle was already enlisted")
    public IllegalStateException alreadyEnlisted();

    @Message(id=59, value="This delayed enlistment handle was already forgotten")
    public IllegalStateException alreadyForgotten();

    @Message(id=60, value="Transaction timed out")
    public XAException transactionTimedOut(@Field int var1);

    @Message(id=61, value="Transaction is marked rollback-only")
    public RollbackException markedRollbackOnly();

    @Message(id=62, value="Transaction is not active")
    public IllegalStateException notActive();

    @Message(id=63, value="Provider created a null transaction")
    public IllegalStateException providerCreatedNullTransaction();

    @Message(id=64, value="Invalid connection endpoint provided")
    public IllegalArgumentException invalidConnectionEndpoint();

    @Message(id=65, value="No transaction for ID %d")
    public SystemException noTransactionForId(int var1);

    @Message(id=66, value="Failed to set transaction as rollback-only")
    public XAException rollbackOnlyFailed(@Field int var1, @Cause SystemException var2);

    @Message(id=67, value="Transaction is not active")
    public XAException notActiveXA(@Field int var1);

    @Message(id=68, value="Subordinate enlistment failed for unknown reason")
    public SystemException couldNotEnlist();

    @Message(id=69, value="Connection does not match the transaction; the connection may have closed")
    public InvalidTransactionException invalidTransactionConnection();

    @Message(id=70, value="No such transaction")
    public XAException noTransactionXa(@Field int var1);

    @Message(id=71, value="An unexpected failure condition occurred")
    public IllegalStateException unexpectedFailure(@Cause Throwable var1);

    @Message(id=72, value="No local transaction provider node name specified in the transaction manager environment")
    public IllegalStateException noLocalTransactionProviderNodeName();

    @Message(id=73, value="Unexpected provider transaction mismatch; expected %s, got %s")
    public IllegalStateException unexpectedProviderTransactionMismatch(Transaction var1, Transaction var2);

    @Message(id=74, value="Heuristic-mixed outcome")
    public XAException heuristicMixedXa(@Field int var1, @Cause HeuristicMixedException var2);

    @Message(id=75, value="Heuristic-commit outcome")
    public XAException heuristicCommitXa(@Field int var1, @Cause HeuristicCommitException var2);

    @Message(id=76, value="Transaction rolled back")
    public XAException rollbackXa(@Field int var1, @Cause RollbackException var2);

    @Message(id=77, value="Heuristic-rollback outcome")
    public XAException heuristicRollbackXa(@Field int var1, @Cause HeuristicRollbackException var2);

    @Message(id=78, value="Invalid transaction state")
    public XAException illegalStateXa(@Field int var1, @Cause IllegalStateException var2);

    @Message(id=79, value="An unexpected resource manager error occurred")
    public XAException resourceManagerErrorXa(@Field int var1, @Cause Throwable var2);

    @Message(id=80, value="Operation not allowed on non-imported transaction")
    public XAException notImportedXa(@Field int var1);

    @Message(id=81, value="Invalid transaction state for operation")
    public XAException invalidTxStateXa(@Field int var1);

    @Message(id=82, value="Cannot import a new transaction on a suspended server")
    public SystemException suspendedCannotCreateNew();

    @Message(id=83, value="Cannot import a new transaction on a suspended server")
    public XAException suspendedCannotImportXa(@Field int var1);

    @Message(id=84, value="UserTransaction access is forbidden in the current context")
    public IllegalStateException forbiddenContextForUserTransaction();

    @Message(id=85, value="Operation failed with an unexpected exception type")
    public SystemException unexpectedException(@Cause Exception var1);

    @Message(id=86, value="Unexpected transaction type encountered; expected %s but encountered %s")
    public IllegalStateException unknownTransactionType(Class<?> var1, Class<?> var2);

    @Message(id=87, value="Unknown transaction manager type %s")
    public IllegalArgumentException unknownTransactionManagerType(Class<?> var1);

    @Message(id=88, value="User %s does not have permission %s")
    public SecurityException noPermission(String var1, Permission var2);

    @Message(id=89, value="Failed to configure transaction timeout of %d")
    public SystemException setTimeoutFailed(int var1, @Cause XAException var2);
}

