/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.IntSerializer;

public class ExternalizerObjectTable
implements ObjectTable {
    private final Externalizer<Object>[] externalizers;
    private final Map<Class<?>, ObjectTable.Writer> writers = new IdentityHashMap();
    private final IntSerializer indexSerializer;

    public ExternalizerObjectTable(ClassLoader loader) {
        this((Externalizer[])Stream.concat(EnumSet.allOf(DefaultExternalizer.class).stream(), StreamSupport.stream(ServiceLoader.load(Externalizer.class, loader).spliterator(), false)).toArray(Externalizer[]::new));
    }

    @SafeVarargs
    public ExternalizerObjectTable(Externalizer<Object> ... externalizers) {
        this(IndexSerializer.select((int)externalizers.length), externalizers);
    }

    @SafeVarargs
    private ExternalizerObjectTable(final IntSerializer indexSerializer, Externalizer<Object> ... externalizers) {
        this.indexSerializer = indexSerializer;
        this.externalizers = externalizers;
        for (int i = 0; i < externalizers.length; ++i) {
            final Externalizer<Object> externalizer = externalizers[i];
            final int index = i;
            Class targetClass = externalizer.getTargetClass();
            if (this.writers.containsKey(targetClass)) continue;
            ObjectTable.Writer writer = new ObjectTable.Writer(){

                public void writeObject(Marshaller marshaller, Object object) throws IOException {
                    indexSerializer.writeInt((DataOutput)marshaller, index);
                    externalizer.writeObject((ObjectOutput)marshaller, object);
                }
            };
            this.writers.put(targetClass, writer);
        }
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        Class<?> targetClass = object.getClass();
        Class<?> writerClass = targetClass.isEnum() ? ((Enum)object).getDeclaringClass() : targetClass;
        Class<?> superClass = writerClass.getSuperclass();
        while (!this.writers.containsKey(writerClass) && superClass != null && Modifier.isAbstract(superClass.getModifiers())) {
            writerClass = superClass;
            superClass = writerClass.getSuperclass();
        }
        return this.writers.get(writerClass);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int index = this.indexSerializer.readInt((DataInput)unmarshaller);
        if (index >= this.externalizers.length) {
            throw new IllegalStateException();
        }
        return this.externalizers[index].readObject((ObjectInput)unmarshaller);
    }
}

