/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class FileStoreBuilder
extends StoreBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    private final String containerName;
    private volatile ValueDependency<PathManager> pathManager;
    private volatile String relativePath;
    private volatile String relativeTo;

    FileStoreBuilder(PathAddress address) {
        super(address, SingleFileStoreConfigurationBuilder.class);
        this.containerName = address.getParent().getParent().getLastElement().getValue();
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return this.pathManager.register(super.build(target));
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.pathManager = new InjectedValueDependency(CommonRequirement.PATH_MANAGER.getServiceName(context), PathManager.class);
        this.relativePath = ModelNodes.optionalString((ModelNode)FileStoreResourceDefinition.Attribute.RELATIVE_PATH.resolveModelAttribute((ExpressionResolver)context, model)).orElse("infinispan" + File.separatorChar + this.containerName);
        this.relativeTo = FileStoreResourceDefinition.Attribute.RELATIVE_TO.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return super.configure(context, model);
    }

    @Override
    public void accept(SingleFileStoreConfigurationBuilder builder) {
        builder.location(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.relativePath, this.relativeTo));
    }
}

