/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class StateTransferBuilder
extends ComponentBuilder<StateTransferConfiguration> {
    private volatile int chunkSize;
    private volatile long timeout;

    StateTransferBuilder(PathAddress address) {
        super(CacheComponent.STATE_TRANSFER, address);
    }

    public StateTransferConfiguration getValue() {
        return new ConfigurationBuilder().clustering().stateTransfer().chunkSize(this.chunkSize).fetchInMemoryState(true).timeout(this.timeout).create();
    }

    public Builder<StateTransferConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.chunkSize = StateTransferResourceDefinition.Attribute.CHUNK_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.timeout = StateTransferResourceDefinition.Attribute.TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }
}

