/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.registry.CacheRegistry;
import org.wildfly.clustering.server.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.FunctionalRegistryFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class CacheRegistryFactoryBuilder<K, V>
implements CapabilityServiceBuilder<RegistryFactory<K, V>>,
CacheRegistryConfiguration<K, V> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<Group> group;
    private volatile ValueDependency<Cache> cache;

    public CacheRegistryFactoryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<RegistryFactory<K, V>> configure(CapabilityServiceSupport support) {
        this.cache = new InjectedValueDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName), Cache.class);
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        Value value = () -> new FunctionalRegistryFactory((entry, closeTask) -> new CacheRegistry(this, entry, (Runnable)closeTask));
        ServiceBuilder builder = target.addService(this.name, (Service)new ValueService(value)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.cache, this.group).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }

    @Override
    public Group<Address> getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<Node, Map.Entry<K, V>> getCache() {
        return (Cache)this.cache.getValue();
    }
}

