/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class FutureUpdate {
    private final UUID uuid;
    private final long timestamp;
    private final Object value;

    public FutureUpdate(UUID uuid, long timestamp, Object value) {
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FutureUpdate{");
        sb.append("uuid=").append(this.uuid);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Object getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static class Externalizer
    implements AdvancedExternalizer<FutureUpdate> {
        public void writeObject(ObjectOutput output, FutureUpdate object) throws IOException {
            output.writeLong(object.uuid.getMostSignificantBits());
            output.writeLong(object.uuid.getLeastSignificantBits());
            output.writeLong(object.timestamp);
            output.writeObject(object.value);
        }

        public FutureUpdate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long msb = input.readLong();
            long lsb = input.readLong();
            long timestamp = input.readLong();
            Object value = input.readObject();
            return new FutureUpdate(new UUID(msb, lsb), timestamp, value);
        }

        public Set<Class<? extends FutureUpdate>> getTypeClasses() {
            return Collections.singleton(FutureUpdate.class);
        }

        public Integer getId() {
            return 1204;
        }
    }
}

