/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.jar.JarFile;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.FilteredIterableResourceLoader;
import org.jboss.modules.FilteredResourceLoader;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.PathResourceLoader;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.filter.PathFilter;

public final class ResourceLoaders {
    static final boolean USE_INDEXES = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.use-indexes", "false")));
    static final boolean WRITE_INDEXES = USE_INDEXES && Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.write-indexes", "false")));

    private ResourceLoaders() {
    }

    public static IterableResourceLoader createFileResourceLoader(String name, File root) {
        return new FileResourceLoader(name, root, AccessController.getContext());
    }

    public static /* bridge */ /* synthetic */ ResourceLoader createFileResourceLoader(String name, File root) {
        return ResourceLoaders.createFileResourceLoader(name, root);
    }

    public static IterableResourceLoader createIterableFileResourceLoader(String name, File root) {
        return ResourceLoaders.createFileResourceLoader(name, root);
    }

    public static IterableResourceLoader createJarResourceLoader(String name, JarFile jarFile) {
        return new JarFileResourceLoader(name, jarFile);
    }

    public static /* bridge */ /* synthetic */ ResourceLoader createJarResourceLoader(String name, JarFile jarFile) {
        return ResourceLoaders.createJarResourceLoader(name, jarFile);
    }

    public static IterableResourceLoader createJarResourceLoader(String name, JarFile jarFile, String relativePath) {
        return new JarFileResourceLoader(name, jarFile, relativePath);
    }

    @Deprecated
    public static IterableResourceLoader createIterableJarResourceLoader(String name, JarFile jarFile) {
        return ResourceLoaders.createJarResourceLoader(name, jarFile);
    }

    public static ResourceLoader createFilteredResourceLoader(PathFilter pathFilter, ResourceLoader originalLoader) {
        return originalLoader instanceof IterableResourceLoader ? new FilteredIterableResourceLoader(pathFilter, (IterableResourceLoader)originalLoader) : new FilteredResourceLoader(pathFilter, originalLoader);
    }

    public static IterableResourceLoader createFilteredResourceLoader(PathFilter pathFilter, IterableResourceLoader originalLoader) {
        return new FilteredIterableResourceLoader(pathFilter, originalLoader);
    }

    public static IterableResourceLoader createIterableFilteredResourceLoader(PathFilter pathFilter, IterableResourceLoader originalLoader) {
        return ResourceLoaders.createFilteredResourceLoader(pathFilter, originalLoader);
    }

    public static IterableResourceLoader createPathResourceLoader(String name, Path path) {
        return new PathResourceLoader(name, path, AccessController.getContext());
    }
}

