/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.subsystem.QueuelessThreadPoolFactory;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactory;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.ServiceNameProvider;

public class ThreadPoolFactoryBuilder
extends QueuelessThreadPoolFactory
implements ResourceServiceBuilder<ThreadPoolFactory> {
    private final ThreadPoolDefinition definition;
    private final ServiceNameProvider serviceNameProvider;

    public ThreadPoolFactoryBuilder(ThreadPoolDefinition definition, PathAddress address) {
        this.definition = definition;
        this.serviceNameProvider = new ThreadPoolServiceNameProvider(address);
    }

    public ServiceName getServiceName() {
        return this.serviceNameProvider.getServiceName();
    }

    public Builder<ThreadPoolFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.setMinThreads(this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt());
        this.setMaxThreads(this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt());
        this.setKeepAliveTime(this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong());
        return this;
    }

    public ServiceBuilder<ThreadPoolFactory> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)new ImmediateValue((Object)this)));
    }
}

