/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Optional;
import java.util.function.Supplier;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.ServiceConfigurator;

public class TransactionServiceConfigurator
extends ComponentServiceConfigurator<TransactionConfiguration> {
    private volatile Supplier<TransactionManager> tm;
    private volatile Supplier<TransactionSynchronizationRegistry> tsr;
    private volatile LockingMode locking;
    private volatile long timeout;
    private volatile TransactionMode mode;

    public TransactionServiceConfigurator(PathAddress address) {
        super(CacheComponent.TRANSACTION, address);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        switch (this.mode) {
            case NONE: {
                break;
            }
            case BATCH: {
                this.tm = new Supplier<TransactionManager>(){

                    @Override
                    public TransactionManager get() {
                        return EmbeddedTransactionManager.getInstance();
                    }
                };
                break;
            }
            case NON_XA: {
                this.tsr = builder.requires(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY);
            }
            default: {
                this.tm = builder.requires(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER);
            }
        }
        return super.register(builder);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.mode = (TransactionMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.MODE.resolveModelAttribute((ExpressionResolver)context, model), TransactionMode.class);
        this.locking = (LockingMode)ModelNodes.asEnum((ModelNode)TransactionResourceDefinition.Attribute.LOCKING.resolveModelAttribute((ExpressionResolver)context, model), LockingMode.class);
        this.timeout = TransactionResourceDefinition.Attribute.STOP_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }

    @Override
    public TransactionConfiguration get() {
        return new ConfigurationBuilder().transaction().lockingMode(this.locking).cacheStopTimeout(this.timeout).transactionManagerLookup((TransactionManagerLookup)Optional.ofNullable(this.tm).map(Supplier::get).map(TransactionManagerProvider::new).orElse(null)).transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)Optional.ofNullable(this.tsr).map(Supplier::get).map(TransactionSynchronizationRegistryProvider::new).orElse(null)).transactionMode(this.mode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL).useSynchronization(this.mode == TransactionMode.NON_XA).recovery().enabled(this.mode == TransactionMode.FULL_XA).transaction().create();
    }
}

