/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.nio.file.Path;
import org.wildfly.core.embedded.SystemPropertyContext;

final class StandaloneSystemPropertyContext
extends SystemPropertyContext {
    private static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SERVER_CONTENT_DIR = "jboss.server.content.dir";
    private static final String SERVER_DATA_DIR = "jboss.server.data.dir";
    private static final String SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    private static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    private static final String SERVER_TEMP_DIR = "jboss.server.temp.dir";

    StandaloneSystemPropertyContext(Path jbossHomeDir) {
        super(jbossHomeDir);
    }

    @Override
    void configureProperties() {
        Path baseDir = this.resolveBaseDir(SERVER_BASE_DIR, "standalone");
        this.addPropertyIfAbsent(SERVER_BASE_DIR, baseDir.toString());
        this.addPropertyIfAbsent(SERVER_CONFIG_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "configuration"));
        this.addPropertyIfAbsent(SERVER_DATA_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "data"));
        this.addPropertyIfAbsent(SERVER_CONTENT_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "data", "content"));
        this.addPropertyIfAbsent(SERVER_DEPLOY_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "data", "content"));
        this.addPropertyIfAbsent(SERVER_LOG_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "log"));
        this.addPropertyIfAbsent(SERVER_TEMP_DIR, StandaloneSystemPropertyContext.resolvePath(baseDir, "tmp"));
    }
}

