/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceConfiguratorAdapter;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceName;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryServiceConfigurator;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.EvictableDataContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceDependency;
import org.wildfly.clustering.service.concurrent.RemoveOnCancelScheduledExecutorServiceConfigurator;

public class InfinispanBeanManagerFactoryServiceConfiguratorFactory<I>
implements BeanManagerFactoryServiceConfiguratorFactory {
    private static final ThreadFactory EXPIRATION_THREAD_FACTORY = InfinispanBeanManagerFactoryServiceConfiguratorFactory.createThreadFactory();
    private final CapabilityServiceSupport support;
    private final String name;
    private final BeanManagerFactoryServiceConfiguratorConfiguration config;

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(InfinispanBeanManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    static String getCacheName(ServiceName deploymentUnitServiceName) {
        if (Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(deploymentUnitServiceName)) {
            return deploymentUnitServiceName.getParent().getSimpleName() + "/" + deploymentUnitServiceName.getSimpleName();
        }
        return deploymentUnitServiceName.getSimpleName();
    }

    public InfinispanBeanManagerFactoryServiceConfiguratorFactory(CapabilityServiceSupport support, String name, BeanManagerFactoryServiceConfiguratorConfiguration config) {
        this.support = support;
        this.name = name;
        this.config = config;
    }

    public Collection<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(ServiceName name) {
        String cacheName = InfinispanBeanManagerFactoryServiceConfiguratorFactory.getCacheName(name);
        String containerName = this.config.getContainerName();
        String templateCacheName = this.config.getCacheName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            int size;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, templateCacheName));
            }
            EvictionStrategy strategy = (size = this.config.getMaxSize()) > 0 ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().evictionStrategy(strategy).evictionType(EvictionType.COUNT).storageType(StorageType.OBJECT).size((long)size);
            if (strategy.isEnabled()) {
                builder.dataContainer().dataContainer((DataContainer)new EvictableDataContainer((long)size, BeanGroupKey.class::isInstance));
            }
        };
        ArrayList<CapabilityServiceConfigurator> builders = new ArrayList<CapabilityServiceConfigurator>(4);
        builders.add((CapabilityServiceConfigurator)new TemplateConfigurationServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, cacheName)), containerName, cacheName, templateCacheName, configurator));
        builders.add((CapabilityServiceConfigurator)new CacheServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, cacheName)), containerName, cacheName).require((Dependency)new ServiceDependency(name.append(new String[]{"marshalling"}))));
        builders.add((CapabilityServiceConfigurator)new ServiceConfiguratorAdapter((ServiceConfigurator)new RemoveOnCancelScheduledExecutorServiceConfigurator(name.append(new String[]{this.name, "expiration"}), EXPIRATION_THREAD_FACTORY)));
        return builders;
    }

    public ServiceConfigurator getBeanManagerFactoryServiceConfigurator(BeanContext context) {
        return new InfinispanBeanManagerFactoryServiceConfigurator(this.support, this.name, context, this.config);
    }
}

