/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.util.Set;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.impl.BusyConnectorsLoadMetric;
import org.jboss.modcluster.load.metric.impl.ReceiveTrafficLoadMetric;
import org.jboss.modcluster.load.metric.impl.RequestCountLoadMetric;
import org.jboss.modcluster.load.metric.impl.SendTrafficLoadMetric;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterServiceConfigurator;
import org.wildfly.mod_cluster.undertow.metric.BytesReceivedHttpHandler;
import org.wildfly.mod_cluster.undertow.metric.BytesSentHttpHandler;
import org.wildfly.mod_cluster.undertow.metric.RequestCountHttpHandler;
import org.wildfly.mod_cluster.undertow.metric.RunningRequestsHttpHandler;

public class ModClusterUndertowDeploymentProcessor
implements DeploymentUnitProcessor {
    private final Set<LoadMetric> enabledMetrics;

    public ModClusterUndertowDeploymentProcessor(Set<LoadMetric> enabledMetrics) {
        this.enabledMetrics = enabledMetrics;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)UndertowEventHandlerAdapterServiceConfigurator.SERVICE_NAME);
        if (this.isMetricEnabled(RequestCountLoadMetric.class)) {
            deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS, (Object)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new RequestCountHttpHandler(handler);
                }
            });
        }
        if (this.isMetricEnabled(SendTrafficLoadMetric.class)) {
            deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS, (Object)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new BytesSentHttpHandler(handler);
                }
            });
        }
        if (this.isMetricEnabled(ReceiveTrafficLoadMetric.class)) {
            deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS, (Object)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new BytesReceivedHttpHandler(handler);
                }
            });
        }
        if (this.isMetricEnabled(BusyConnectorsLoadMetric.class)) {
            deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_OUTER_HANDLER_CHAIN_WRAPPERS, (Object)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new RunningRequestsHttpHandler(handler);
                }
            });
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isMetricEnabled(Class metricClass) {
        for (LoadMetric enabledMetric : this.enabledMetrics) {
            if (!metricClass.isInstance(enabledMetric)) continue;
            return true;
        }
        return false;
    }
}

