/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.config.ModClusterConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;

public class ContainerEventHandlerServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
Supplier<ModClusterService>,
Consumer<ModClusterService> {
    public static final ServiceName SERVICE_NAME = ModClusterConfigResourceDefinition.MOD_CLUSTER_CAPABILITY.getCapabilityServiceName();
    public static final ServiceName CONFIG_SERVICE_NAME = SERVICE_NAME.append(new String[]{"config"});
    private final LoadBalanceFactorProvider load;
    private volatile Supplier<ModClusterConfiguration> configuration;

    ContainerEventHandlerServiceConfigurator(LoadBalanceFactorProvider factorProvider) {
        super(SERVICE_NAME);
        this.load = factorProvider;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        Consumer modClusterService = builder.addAliases(new ServiceName[]{ServiceName.JBOSS.append(new String[]{"modcluster"})}).provides(new ServiceName[]{this.getServiceName()});
        this.configuration = builder.requires(CONFIG_SERVICE_NAME);
        FunctionalService service = new FunctionalService(modClusterService, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public ModClusterService get() {
        return new ModClusterService(this.configuration.get(), this.load);
    }

    @Override
    public void accept(ModClusterService service) {
        service.shutdown();
    }
}

