/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.wildfly.clustering.service.ActiveServiceSupplier;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerServiceConfigurator;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;

public class ModClusterAddProxy
implements OperationStepHandler {
    static final ModClusterAddProxy INSTANCE = new ModClusterAddProxy();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("add-proxy", descriptionResolver).addParameter((AttributeDefinition)ModClusterSubsystemResourceDefinition.HOST).addParameter((AttributeDefinition)ModClusterSubsystemResourceDefinition.PORT).setRuntimeOnly().addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ContainerEventHandlerServiceConfigurator.SERVICE_NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ModClusterServiceMBean service = (ModClusterServiceMBean)new ActiveServiceSupplier(context.getServiceRegistry(true), ContainerEventHandlerServiceConfigurator.SERVICE_NAME).get();
                    ModClusterLogger.ROOT_LOGGER.debugf("add-proxy: %s", operation);
                    final String host = ModClusterSubsystemResourceDefinition.HOST.resolveModelAttribute(context, operation).asString();
                    final int port = ModClusterSubsystemResourceDefinition.PORT.resolveModelAttribute(context, operation).asInt();
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException e) {
                        throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.couldNotResolveProxyIpAddress(), (Throwable)e);
                    }
                    service.addProxy(host, port);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            service.removeProxy(host, port);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

