/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;

public final class WriteOnlyKeyCommand<K, V>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 54;
    private Consumer<EntryView.WriteEntryView<K, V>> f;

    public WriteOnlyKeyCommand(Object key, Consumer<EntryView.WriteEntryView<K, V>> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, valueMatcher, id, params, keyDataConversion, valueDataConversion);
        this.f = f;
        this.init(componentRegistry);
    }

    public WriteOnlyKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 54;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Consumer)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        boolean exists = e.getValue() != null;
        this.f.accept(EntryViews.writeOnly(e, this.valueDataConversion));
        if (!e.isChanged() && !this.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.successful = false;
        }
        return Param.StatisticsMode.isSkip(this.params) ? null : StatsEnvelope.create(null, e, exists, false);
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.Write<K, V>(this.keyDataConversion, this.valueDataConversion, this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public Consumer<EntryView.WriteEntryView<K, V>> getConsumer() {
        return this.f;
    }
}

