/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.executor.DaemonThreadFactory;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.api.ExecutorServices;

public abstract class AbstractExecutorServices
implements ExecutorServices {
    private static final long SHUTDOWN_TIMEOUT = 60L;
    private final ScheduledExecutorService timerExecutor = Executors.newScheduledThreadPool(1, new DaemonThreadFactory(new ThreadGroup("weld-workers"), "weld-timer-"));

    public ScheduledExecutorService getTimerExecutor() {
        return this.timerExecutor;
    }

    public <T> List<Future<T>> invokeAllAndCheckForExceptions(Collection<? extends Callable<T>> tasks) {
        try {
            return this.checkForExceptions(this.getTaskExecutor().invokeAll(tasks));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DeploymentException(e);
        }
    }

    public <T> List<Future<T>> invokeAllAndCheckForExceptions(ExecutorServices.TaskFactory<T> factory) {
        return this.invokeAllAndCheckForExceptions(factory.createTasks(this.getThreadPoolSize()));
    }

    protected <T> List<Future<T>> checkForExceptions(List<Future<T>> futures) {
        for (Future<T> result : futures) {
            try {
                result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WeldException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)RuntimeException.class.cast(cause);
                }
                throw new WeldException(cause);
            }
        }
        return futures;
    }

    protected abstract int getThreadPoolSize();

    public void cleanup() {
        this.shutdown();
    }

    protected void shutdown() {
        this.getTaskExecutor().shutdown();
        this.getTimerExecutor().shutdown();
        try {
            if (!this.getTaskExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                this.getTaskExecutor().shutdownNow();
                if (!this.getTaskExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                    BootstrapLogger.LOG.timeoutShuttingDownThreadPool(this.getTaskExecutor(), this);
                }
            }
        }
        catch (InterruptedException ie) {
            this.getTaskExecutor().shutdownNow();
            Thread.currentThread().interrupt();
        }
        try {
            if (!this.getTimerExecutor().isShutdown()) {
                this.getTimerExecutor().shutdownNow();
                if (!this.getTimerExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                    BootstrapLogger.LOG.timeoutShuttingDownThreadPool(this.getTimerExecutor(), this);
                }
            }
        }
        catch (InterruptedException ie) {
            this.getTimerExecutor().shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

